/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.dirtree;

import com.atlassian.crucible.actions.AjaxResponse;
import com.atlassian.fisheye.activity.RssFeedUrlBuilder;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.web.FishEyePathInfo;
import com.cenqua.fisheye.web.FisheyeRepositoryExplorer;
import com.cenqua.fisheye.web.PreferenceManager;
import com.cenqua.fisheye.web.RepositoryAction;
import com.cenqua.fisheye.web.ServletUtils;
import com.cenqua.fisheye.web.WaybackSpec;
import com.cenqua.fisheye.web.dirtree.FisheyeFileTableData;
import com.cenqua.fisheye.web.parameterbeans.ViewRepositoryServletParams;
import com.opensymphony.webwork.interceptor.ServletRequestAware;
import javax.servlet.http.HttpServletRequest;

public class LoadFilePaneAction
extends RepositoryAction
implements AjaxResponse,
ServletRequestAware {
    private String errorMsg;
    private String href;
    private String repName;
    private FisheyeFileTableData fileTableData;
    private String origUrl;
    private HttpServletRequest request;

    private FishEyePathInfo parsePathInfo(String pathInfo) throws IllegalArgumentException {
        FishEyePathInfo pi = new FishEyePathInfo(pathInfo);
        if (pi.getFullPath().isAbove()) {
            throw new IllegalArgumentException("Relative path specified " + pi.getFullPath());
        }
        return pi;
    }

    protected WaybackSpec parseWaybackSpec(FishEyePathInfo pi) {
        WaybackSpec wbSpec = WaybackSpec.fromPathInfo(pi);
        return wbSpec != null ? wbSpec : new WaybackSpec();
    }

    @RequireSecurityToken(value=false)
    public String execute() {
        try {
            String prefix = this.request.getContextPath() + "/browse";
            if (!this.href.contains(prefix)) {
                throw new RuntimeException("The URL " + this.href + " doesn't contain " + prefix);
            }
            String pathInfoString = this.href.substring(this.href.indexOf(prefix) + prefix.length() + 1);
            FishEyePathInfo pathInfo = this.parsePathInfo(pathInfoString);
            this.repName = pathInfo.getRepname();
            RepositoryHandle repositoryHandle = this.getRepositoryHandle(this.repName);
            pathInfo.initEngine(repositoryHandle);
            WaybackSpec wbSpec = this.parseWaybackSpec(pathInfo);
            RepositoryEngine engine = pathInfo.getEngine();
            Path lpath = pathInfo.getLocalPath();
            FisheyeRepositoryExplorer explorer = new FisheyeRepositoryExplorer(engine, lpath, wbSpec, PreferenceManager.getPreferences(this.request));
            this.fileTableData = new FisheyeFileTableData(explorer, lpath);
            ViewRepositoryServletParams params = new ViewRepositoryServletParams(engine, explorer, lpath, wbSpec);
            RssFeedUrlBuilder builder = new RssFeedUrlBuilder(this.request, "/changelog");
            builder.setAuthenticationRequired(params.getRequiresAuth());
            builder.setPathInfo(pathInfo);
            builder.setView("fe");
            params.setRssFeedUrl(builder.build().toString());
            this.request.setAttribute("p", (Object)params);
            return "success";
        }
        catch (RepositoryAction.RepositoryPermissionException e1) {
            this.errorMsg = "You do not have permission to access repository '" + this.repName + "'";
            return "error";
        }
        catch (Exception e2) {
            Logs.APP_LOG.error((Object)"Exception", (Throwable)e2);
            this.errorMsg = e2.getMessage();
            return "error";
        }
    }

    @Override
    public String getErrorMsg() {
        return this.errorMsg;
    }

    @Override
    public boolean isWorked() {
        return this.errorMsg == null;
    }

    public void setHref(String href) {
        this.href = ServletUtils.decodeString(href);
    }

    public String getRepName() {
        return this.repName;
    }

    public FisheyeFileTableData getFileTableData() {
        return this.fileTableData;
    }

    public String getOrigUrl() {
        return this.origUrl;
    }

    public void setOrigUrl(String origUrl) {
        this.origUrl = origUrl;
    }

    public void setServletRequest(HttpServletRequest request) {
        this.request = request;
    }
}

