/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.dirtree;

import com.atlassian.fisheye.scm.VisibilityPrefData;
import com.cenqua.fisheye.web.CookiePreferences;
import com.cenqua.fisheye.web.PreferenceManager;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

public class GenerateHiddenClassAttribute {
    public static String hiddenClasses(VisibilityPrefData prefs, String otherClasses) {
        StringBuilder sb = new StringBuilder();
        if (prefs.isHideDeletedFiles() || prefs.isHideEmptyDirs() || prefs.isHideHiddenDirs() || StringUtils.isNotBlank((String)otherClasses)) {
            String sep = "";
            if (StringUtils.isNotBlank((String)otherClasses)) {
                sb.append(otherClasses.trim());
                sep = " ";
            }
            if (prefs.isHideDeletedFiles()) {
                sep = GenerateHiddenClassAttribute.append(sb, sep, "deleted-hide");
            }
            if (prefs.isHideEmptyDirs()) {
                sep = GenerateHiddenClassAttribute.append(sb, sep, "empty-hide");
            }
            if (prefs.isHideHiddenDirs()) {
                String string = GenerateHiddenClassAttribute.append(sb, sep, "hidden-hide");
            }
        }
        return sb.toString();
    }

    private static String append(StringBuilder sb, String sep, String s2) {
        sb.append(sep).append(s2);
        return " ";
    }

    public static VisibilityPrefData visibilityPrefs(HttpServletRequest req) {
        CookiePreferences prefs = PreferenceManager.getPreferences(req);
        return new VisibilityPrefDataImpl("Y".equals(prefs.getPreference(CookiePreferences.Pref.HIDE_HIDDEN)), "Y".equals(prefs.getPreference(CookiePreferences.Pref.HIDE_EMPTY)), prefs.isHideDeletedFiles());
    }

    private static class VisibilityPrefDataImpl
    implements VisibilityPrefData {
        private boolean hideHidden;
        private boolean hideEmpty;
        private boolean hideDeleted;

        private VisibilityPrefDataImpl(boolean hideHidden, boolean hideEmpty, boolean hideDeleted) {
            this.hideHidden = hideHidden;
            this.hideEmpty = hideEmpty;
            this.hideDeleted = hideDeleted;
        }

        @Override
        public boolean isHideHiddenDirs() {
            return this.hideHidden;
        }

        @Override
        public boolean isHideEmptyDirs() {
            return this.hideEmpty;
        }

        @Override
        public boolean isHideDeletedFiles() {
            return this.hideDeleted;
        }
    }
}

