/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.dirtree;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.DirInfo;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.util.AntGlob;
import com.cenqua.fisheye.util.RevisionDateRange;
import com.cenqua.fisheye.web.FisheyeRepositoryExplorer;
import com.cenqua.fisheye.web.dirtree.DirTreeCache;
import com.cenqua.fisheye.web.dirtree.PathFilterFactory;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class FisheyeFileTableData {
    private final FisheyeRepositoryExplorer explorer;
    private final Path currentDirectory;
    private final PathFilterFactory.PathFilter pathFilter;

    public FisheyeFileTableData(FisheyeRepositoryExplorer explorer, Path currentDirectory) {
        this.explorer = explorer;
        this.currentDirectory = currentDirectory;
        this.pathFilter = PathFilterFactory.getPathFilter(explorer.getEngine(), explorer.wb);
    }

    public List<FileOrDirectory> getFilesAndDirectories() throws DbException {
        final ArrayList<FileOrDirectory> l2 = new ArrayList<FileOrDirectory>();
        final List<AntGlob> hideDirectoryPatterns = this.explorer.getEngine().getCfg().getHideDirectoryPatterns();
        this.explorer.getEngine().getDirTreeCache().calculateWith(this.explorer.wb, new DirTreeCache.Visitor(){

            @Override
            public void visit(DirTreeCache.Context calc) throws DbException {
                for (Path p2 : ((FisheyeFileTableData)FisheyeFileTableData.this).explorer.cRep.listDirs(FisheyeFileTableData.this.currentDirectory)) {
                    TableDirData.Builder builder = new TableDirData.Builder(p2).empty(this.isPathEmptyOfFiles(p2, calc)).hidden(FisheyeFileTableData.this.isHidden(p2, hideDirectoryPatterns));
                    DirInfo dirInfo = ((FisheyeFileTableData)FisheyeFileTableData.this).explorer.cRep.findDirInfo(p2);
                    if (dirInfo != null) {
                        RevisionDateRange subTreeDateRange = dirInfo.getSubTreeDateRange();
                        if (subTreeDateRange.hasMaxRevisionInfo()) {
                            builder.fileRevision(((FisheyeFileTableData)FisheyeFileTableData.this).explorer.cRep.getFileRevision(subTreeDateRange.getMaxRevId(), true));
                        } else if (subTreeDateRange.hasMinMax()) {
                            builder.date(new Date((Long)subTreeDateRange.getMax().get()));
                        }
                    }
                    l2.add(builder.build());
                }
                for (FisheyeRepositoryExplorer.FisheyeFileExplorerInfo file : FisheyeFileTableData.this.explorer.getFiles()) {
                    if (FisheyeFileTableData.this.pathFilter != null && FisheyeFileTableData.this.pathFilter.shouldIgnore(FisheyeFileTableData.this.currentDirectory)) continue;
                    l2.add(new TableFileData(file, FisheyeFileTableData.this.isHidden(file.getPath(), hideDirectoryPatterns)));
                }
            }

            private boolean isPathEmptyOfFiles(Path p2, DirTreeCache.Context calc) {
                return calc.isEmptyOfFiles(p2);
            }
        });
        return l2;
    }

    private boolean isHidden(Path p2, List<AntGlob> hideDirectoryPatterns) {
        if (hideDirectoryPatterns.isEmpty()) {
            return false;
        }
        for (AntGlob glob : hideDirectoryPatterns) {
            if (!glob.matches(p2.toString())) continue;
            return true;
        }
        return false;
    }

    public String getRepName() {
        return this.explorer.getRepName();
    }

    public Path getPath() {
        return this.currentDirectory;
    }

    private static class TableDirData
    implements FileOrDirectory {
        private final Path path;
        private final boolean empty;
        private final boolean hidden;
        private final Date date;
        private final String author;
        private final String revision;
        private final String displayRevision;
        private final String changesetId;
        private final boolean revisionIsChangeset;

        private TableDirData(Path path, boolean empty, boolean hidden, Date date, String author, String revision, String displayRevision, String changesetId, boolean revisionIsChangeset) {
            this.path = path;
            this.empty = empty;
            this.hidden = hidden;
            this.date = date;
            this.author = author;
            this.revision = revision;
            this.displayRevision = displayRevision;
            this.changesetId = changesetId;
            this.revisionIsChangeset = revisionIsChangeset;
        }

        @Override
        public boolean isFile() {
            return false;
        }

        @Override
        public String getType() {
            return "directory";
        }

        @Override
        public String getName() {
            return this.path.getName();
        }

        @Override
        public String getRevision() {
            return this.revision;
        }

        @Override
        public String getDisplayRevision() {
            return this.displayRevision;
        }

        @Override
        public Date getDate() {
            return this.date;
        }

        @Override
        public String getAuthor() {
            return this.author;
        }

        @Override
        public boolean isAuthorEmpty() {
            return this.author == null || this.author.equals("-");
        }

        @Override
        public Path getPath() {
            return this.path;
        }

        @Override
        public String getChangesetId() {
            return this.changesetId;
        }

        @Override
        public boolean isChangesetIdEmpty() {
            return this.getChangesetId() == null || this.getChangesetId().equals("-");
        }

        @Override
        public boolean isDeleted() {
            return false;
        }

        @Override
        public boolean isEmptyDir() {
            return this.empty;
        }

        @Override
        public boolean isBinary() {
            return false;
        }

        @Override
        public boolean isOversize() {
            return false;
        }

        @Override
        public boolean isHidden() {
            return this.hidden;
        }

        @Override
        public boolean isRevisionIsChangeset() {
            return this.revisionIsChangeset;
        }

        static class Builder {
            boolean empty;
            boolean hidden;
            String revision = "-";
            String displayRevision = "-";
            Date date;
            String author = "-";
            Path path;
            String changesetId = "-";
            boolean revisionIsChangeset = false;

            Builder(Path path) {
                this.path = path;
            }

            Builder empty(boolean empty) {
                this.empty = empty;
                return this;
            }

            Builder hidden(boolean hidden) {
                this.hidden = hidden;
                return this;
            }

            Builder date(Date date) {
                this.date = date;
                return this;
            }

            Builder fileRevision(FileRevision fileRevision) {
                if (fileRevision != null) {
                    this.date = fileRevision.getDateValue();
                    this.author = fileRevision.getAuthor();
                    this.revision = fileRevision.getRevision();
                    this.displayRevision = fileRevision.getDisplayRevision();
                    this.changesetId = fileRevision.getDisplayCSID();
                    this.revisionIsChangeset = fileRevision.isRevisionChangesetId();
                }
                return this;
            }

            TableDirData build() {
                return new TableDirData(this.path, this.empty, this.hidden, this.date, this.author, this.revision, this.displayRevision, this.changesetId, this.revisionIsChangeset);
            }
        }
    }

    private static class TableFileData
    implements FileOrDirectory {
        private final FisheyeRepositoryExplorer.FisheyeFileExplorerInfo file;
        private final boolean hidden;

        public TableFileData(FisheyeRepositoryExplorer.FisheyeFileExplorerInfo file, boolean hidden) {
            this.file = file;
            this.hidden = hidden;
        }

        @Override
        public boolean isFile() {
            return true;
        }

        @Override
        public String getType() {
            return "file";
        }

        @Override
        public String getName() {
            return this.file.getPath().getName();
        }

        @Override
        public String getRevision() {
            FileRevision revision = this.file.getLatestRevision();
            return revision == null ? "" : revision.getRevision();
        }

        @Override
        public String getDisplayRevision() {
            FileRevision revision = this.file.getLatestRevision();
            return revision == null ? "" : revision.getDisplayRevision();
        }

        @Override
        public Date getDate() {
            FileRevision revision = this.file.getLatestRevision();
            return revision == null ? null : new Date(revision.getDate());
        }

        @Override
        public String getAuthor() {
            FileRevision revision = this.file.getLatestRevision();
            return revision == null ? "" : revision.getAuthor();
        }

        @Override
        public boolean isAuthorEmpty() {
            return this.getAuthor() == null || this.getAuthor().equals("-");
        }

        @Override
        public Path getPath() {
            return this.file.getPath();
        }

        @Override
        public String getChangesetId() {
            FileRevision revision = this.file.getLatestRevision();
            return revision == null ? "" : revision.getDisplayCSID();
        }

        @Override
        public boolean isChangesetIdEmpty() {
            return this.getChangesetId() == null || this.getChangesetId().equals("-");
        }

        @Override
        public boolean isDeleted() {
            FileRevision revision = this.file.getLatestRevision();
            return revision != null && revision.isDead();
        }

        @Override
        public boolean isEmptyDir() {
            return false;
        }

        @Override
        public boolean isHidden() {
            return this.hidden;
        }

        @Override
        public boolean isBinary() {
            FileRevision revision = this.file.getLatestRevision();
            return revision != null && revision.isBinary();
        }

        @Override
        public boolean isOversize() {
            FileRevision revision = this.file.getLatestRevision();
            return revision != null && revision.isOversize();
        }

        @Override
        public boolean isRevisionIsChangeset() {
            FileRevision revision = this.file.getLatestRevision();
            return revision != null && revision.isRevisionChangesetId();
        }
    }

    public static interface FileOrDirectory {
        public static final String DASH = "-";

        public boolean isFile();

        public String getType();

        public String getName();

        public String getRevision();

        public String getDisplayRevision();

        public Date getDate();

        public String getAuthor();

        public boolean isAuthorEmpty();

        public Path getPath();

        public String getChangesetId();

        public boolean isChangesetIdEmpty();

        public boolean isDeleted();

        public boolean isEmptyDir();

        public boolean isHidden();

        public boolean isBinary();

        public boolean isOversize();

        public boolean isRevisionIsChangeset();
    }

    public static class TarballData {
        private final String fileName;

        public TarballData(String fileName) {
            this.fileName = fileName;
        }

        public String getFileName() {
            return this.fileName;
        }
    }
}

