/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.dirtree;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.util.Pair;
import com.cenqua.fisheye.web.FisheyeRepositoryExplorer;
import com.cenqua.fisheye.web.dirtree.AbstractLazyDirTree;
import com.cenqua.fisheye.web.dirtree.DirTreeCache;
import com.cenqua.fisheye.web.dirtree.PathFilterFactory;
import java.util.List;

public class FisheyeDirTreeData
extends AbstractLazyDirTree {
    private static final long MAX_TREE_BUILD_TIME = 200L;

    public static FisheyeDirTreeData create(FisheyeRepositoryExplorer fisheyeRepoExplorer, Path rootPath, Path selectedPath, boolean dontShowFiles) throws DbException {
        return FisheyeDirTreeData.create(fisheyeRepoExplorer, rootPath, selectedPath, dontShowFiles, false);
    }

    public static FisheyeDirTreeData create(final FisheyeRepositoryExplorer fisheyeRepoExplorer, final Path rootPath, final Path selectedPath, final boolean dontShowFiles, final boolean noData) throws DbException {
        final FisheyeDirTreeData[] returnValue = new FisheyeDirTreeData[1];
        fisheyeRepoExplorer.engine.getDirTreeCache().calculateWith(fisheyeRepoExplorer.wb, new DirTreeCache.Visitor(){

            @Override
            public void visit(DirTreeCache.Context calc) throws DbException {
                returnValue[0] = new FisheyeDirTreeData(fisheyeRepoExplorer, calc, rootPath, selectedPath, dontShowFiles, noData);
            }
        });
        return returnValue[0];
    }

    private FisheyeDirTreeData(final FisheyeRepositoryExplorer rep, final DirTreeCache.Context calc, Path rootPath, Path selectedPath, boolean dontShowFiles, final boolean noData) throws DbException {
        super(new AbstractLazyDirTree.PathExplorer(){

            @Override
            public AbstractLazyDirTree.PathInfo[] listSubTree(Path parent) throws DbException {
                if (noData) {
                    return new AbstractLazyDirTree.PathInfo[0];
                }
                Path[] dirs = rep.cRep.listDirs(parent);
                List<Path> files = rep.listFilePaths(parent);
                AbstractLazyDirTree.PathInfo[] children = new AbstractLazyDirTree.PathInfo[dirs.length + files.size()];
                int i2 = 0;
                for (Path p2 : dirs) {
                    children[i2++] = new AbstractLazyDirTree.PathInfo(p2, false, new Pair[0]);
                }
                for (Path p3 : files) {
                    children[i2++] = new AbstractLazyDirTree.PathInfo(p3, true, new Pair[0]);
                }
                return children;
            }

            @Override
            public FileRevision getLatestFileRevision(Path p2) throws DbException {
                if (noData) {
                    return null;
                }
                List<FileRevision> headRevisions = rep.listHeadRevisions(p2);
                return !headRevisions.isEmpty() ? headRevisions.get(0) : null;
            }

            @Override
            public boolean isEmptyOfFiles(Path p2) {
                if (noData) {
                    return true;
                }
                return calc.isEmptyOfFiles(p2);
            }
        }, rep.getName(), rootPath, selectedPath, dontShowFiles, 200L, rep.up.getPreference("hideEmptyDirectories").equals("Y"), rep.up.getPreference("hideHiddenDirectories").equals("Y"), rep.up.getPreference("hideDeletedFiles").equals("Y"), rep.engine.getCfg().getHideDirectoryPatterns(), PathFilterFactory.getPathFilter(rep.getEngine(), rep.wb));
    }
}

