/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.dirtree;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.lucene.LuceneIndexes;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.web.WaybackSpec;
import com.cenqua.fisheye.web.dirtree.DirTreeCache;
import com.cenqua.fisheye.web.dirtree.PathFilterFactory;
import java.util.concurrent.ExecutionException;

class DirTreeContextImpl
implements DirTreeCache.Context {
    private final DirTreeCache cache;
    private final PathFilterFactory.PathFilter pathFilter;
    private final WaybackSpec wbSpec;

    public DirTreeContextImpl(DirTreeCache cache, WaybackSpec wb, PathFilterFactory.PathFilter pathFilter) {
        this.cache = cache;
        this.pathFilter = pathFilter;
        this.wbSpec = wb;
    }

    @Override
    public boolean isEmptyOfFiles(Path path) {
        if (this.pathFilter != null) {
            return this.pathFilter.shouldIgnore(path);
        }
        if (AppConfig.Hacks.DISABLE_DIRTREE_EMPTY_CHECKS) {
            return false;
        }
        try {
            return ((DirTreeCache.Node)this.cache.dirInfoCache.get((Object)new DirTreeCache.CacheKey((WaybackSpec)WaybackSpec.immutableCopyOf((WaybackSpec)this.wbSpec), (Path)path))).isEmpty;
        }
        catch (ExecutionException e2) {
            Logs.APP_LOG.warn((Object)"error counting nonempty files", (Throwable)e2);
            return false;
        }
    }

    void calculateWith(LuceneConnection<LuceneIndexes> conn, DirTreeCache.Visitor v2) throws DbException {
        v2.visit(this);
    }
}

