/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.dirtree;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.lucene.LuceneIndexes;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.web.WaybackSpec;
import com.cenqua.fisheye.web.dirtree.DirTreeContextImpl;
import com.cenqua.fisheye.web.dirtree.PathFilterFactory;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;

public class DirTreeCache {
    private static final int MAX_DIRINFO_ENTRIES = 1000;
    final RepositoryEngine eng;
    final LoadingCache<CacheKey, Node> dirInfoCache = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<CacheKey, Node>(){

        public Node load(CacheKey key) throws Exception {
            String branchName = key.getWbSpec() != null ? key.getWbSpec().getBranch() : null;
            String tagName = key.getWbSpec() != null ? key.getWbSpec().getTag() : null;
            return new Node(DirTreeCache.this.eng.getRevisionCache().isEmptyOfFiles(key.getDir(), branchName, tagName));
        }
    });

    public DirTreeCache(RepositoryEngine eng) {
        this.eng = eng;
    }

    public void invalidate() {
        Logs.APP_LOG.debug((Object)("Invalidating cache for " + this.eng.getName()));
        this.dirInfoCache.invalidateAll();
    }

    public void calculateWith(WaybackSpec wb, Visitor v2) throws DbException {
        LuceneConnection<LuceneIndexes> conn = this.eng.getIndexConnection();
        PathFilterFactory.PathFilter pathFilter = PathFilterFactory.getPathFilter(this.eng, wb);
        DirTreeContextImpl c2 = new DirTreeContextImpl(this, wb, pathFilter);
        c2.calculateWith(conn, v2);
    }

    public void warm() throws DbException {
        this.calculateWith(null, new Visitor(){

            @Override
            public void visit(Context calc) {
                boolean rootEmpty = calc.isEmptyOfFiles(Path.ROOT);
                Logs.APP_LOG.info((Object)("Warming " + DirTreeCache.this.eng.getName() + ", rootempty=" + rootEmpty));
            }
        });
    }

    static class Node {
        public final boolean isEmpty;

        public Node(boolean empty) {
            this.isEmpty = empty;
        }
    }

    static class CacheKey {
        private final WaybackSpec wbSpec;
        private final Path dir;

        public CacheKey(WaybackSpec wbSpec, Path dir) {
            this.wbSpec = wbSpec;
            this.dir = dir;
        }

        WaybackSpec getWbSpec() {
            return this.wbSpec;
        }

        Path getDir() {
            return this.dir;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            CacheKey key = (CacheKey)o2;
            if (!this.dir.equals(key.dir)) {
                return false;
            }
            if (this.wbSpec == null && key.wbSpec != null) {
                return false;
            }
            return this.wbSpec == null || this.wbSpec.equals(key.wbSpec);
        }

        public int hashCode() {
            int result = this.wbSpec != null ? this.wbSpec.hashCode() : 1;
            result = 29 * result + this.dir.hashCode();
            return result;
        }
    }

    public static interface Visitor {
        public void visit(Context var1) throws DbException;
    }

    public static interface Context {
        public boolean isEmptyOfFiles(Path var1);
    }
}

