/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.dirtree;

import com.atlassian.fisheye.scm.DirNodeData;
import com.atlassian.fisheye.scm.DirTreeData;
import com.atlassian.fisheye.scm.DirTreeDataUtils;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.util.AntGlob;
import com.cenqua.fisheye.util.Pair;
import com.cenqua.fisheye.web.dirtree.PathFilterFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractLazyDirTree
implements DirTreeData {
    private final boolean dontShowFiles;
    private final long maxTreeBuildTime;
    private final PathExplorer pathExplorer;
    private final String repoName;
    private final boolean hideHiddenDirs;
    private final boolean hideEmptyDirs;
    private final boolean repoMayHide;
    private DirNodeData rootNode;
    private final DirNodeData parentNode;
    private boolean containsEmptyDirs;
    private final Path rootPath;
    private final Path selectedPath;
    private long actualTreeBuildTime;
    private static final int MAX_NODES = 200;
    private int nodeCount = 0;
    private final boolean hideDeletedFiles;
    private final List<AntGlob> hiddenPatterns;
    private final PathFilterFactory.PathFilter pathFilter;

    public AbstractLazyDirTree(PathExplorer pathExplorer, String repoName, Path rootPath, Path selectedPath, boolean dontShowFiles, long maxTreeBuildTime, boolean hideEmptyDirs, boolean hideHiddenDirs, boolean hideDeletedFiles, List<AntGlob> hiddenPatterns, PathFilterFactory.PathFilter pathFilter) throws DbException {
        this.pathExplorer = pathExplorer;
        this.repoName = repoName;
        this.rootPath = rootPath;
        this.selectedPath = selectedPath;
        this.dontShowFiles = dontShowFiles;
        this.maxTreeBuildTime = maxTreeBuildTime;
        this.hideEmptyDirs = hideEmptyDirs;
        this.hideHiddenDirs = hideHiddenDirs;
        this.hideDeletedFiles = hideDeletedFiles;
        this.hiddenPatterns = hiddenPatterns;
        this.pathFilter = pathFilter;
        if (!rootPath.isRoot()) {
            this.parentNode = new DirNodeData(rootPath.trimLast(), true, false, null, this.getRootPath().getNumComponents(), selectedPath, new Pair[0]);
            ++this.nodeCount;
            this.parentNode.setSubDirs(Collections.emptyList());
        } else {
            this.parentNode = null;
        }
        Path path = rootPath;
        this.repoMayHide = !hiddenPatterns.isEmpty();
        this.rootNode = new DirNodeData(path, this.isPathEmptyOfFiles(path), this.isDirHidden(path), null, this.getRootPath().getNumComponents(), selectedPath, new Pair[0]);
        ++this.nodeCount;
        LinkedList<DirNodeData> nodesToFill = new LinkedList<DirNodeData>();
        nodesToFill.add(this.rootNode);
        this.fillSubDirs(nodesToFill);
    }

    private void fillSubDirs(LinkedList<DirNodeData> nodesToFill) throws DbException {
        long startTime = System.currentTimeMillis();
        while (!nodesToFill.isEmpty() && !this.stop(startTime, nodesToFill)) {
            DirNodeData node = nodesToFill.removeFirst();
            if (node.isFile() || !this.isNodeRequired(startTime, node)) continue;
            this.computeSubDirs(node);
            if (node.getSubDirs().size() == 1 && !node.getSubDirs().get(0).isFile() && !this.isDirHidden(node.getSubDirs().get(0).getPath())) {
                DirNodeData onlyChild = node.getSubDirs().get(0);
                node.setPath(onlyChild.getPath());
                node.setDeleted(onlyChild.isDeleted());
                node.setSubDirs(null);
                nodesToFill.add(node);
                continue;
            }
            nodesToFill.addAll(node.getSubDirs());
        }
        this.actualTreeBuildTime = System.currentTimeMillis() - startTime;
    }

    private boolean isNodeRequired(long startTime, DirNodeData node) {
        if (this.timeExceeded(startTime) || this.nodeCount > 200) {
            return node == this.rootNode || this.isOnSelectedPath(node);
        }
        return true;
    }

    private boolean isOnSelectedPath(DirNodeData node) {
        return node.getPath().equals(this.getSelectedPath()) || node.getPath().isAncestor(this.getSelectedPath());
    }

    private boolean timeExceeded(long startTime) {
        return System.currentTimeMillis() - startTime > this.maxTreeBuildTime;
    }

    private boolean stop(long startTime, LinkedList<DirNodeData> nodesToFill) {
        return (this.timeExceeded(startTime) || this.nodeCount > 200) && !nodesToFill.contains(this.rootNode) && !this.containsNodeOnSelectedPath(nodesToFill);
    }

    private boolean containsNodeOnSelectedPath(LinkedList<DirNodeData> nodes) {
        if (this.getSelectedPath() != null) {
            for (DirNodeData n2 : nodes) {
                if (!this.isOnSelectedPath(n2)) continue;
                return true;
            }
        }
        return false;
    }

    private void computeSubDirs(DirNodeData node) throws DbException {
        PathInfo[] children = this.pathExplorer.listSubTree(node.getPath());
        FileRevision revision = this.pathExplorer.getLatestFileRevision(this.rootPath);
        if (revision != null) {
            this.rootNode.setDeleted(revision.isDead());
        }
        ArrayList<DirNodeData> dirList = new ArrayList<DirNodeData>(children.length);
        for (PathInfo p2 : children) {
            if (this.dontShowFiles && p2.isFile) continue;
            if (p2.isFile) {
                if (this.pathFilter != null && this.pathFilter.shouldIgnore(p2.path)) continue;
                this.addFilePath(dirList, p2.path, node, p2.attrs);
                continue;
            }
            this.addDirPath(dirList, p2.path, node, p2.attrs);
        }
        node.setSubDirs(dirList);
    }

    private void addDirPath(List<DirNodeData> dirList, Path p2, DirNodeData parent, Pair<String, String>[] attrs) {
        boolean noFiles = this.isPathEmptyOfFiles(p2);
        FileRevision rev = this.pathExplorer.getLatestFileRevision(p2);
        if (rev == null) {
            dirList.add(new DirNodeData(p2, noFiles, this.isDirHidden(p2), parent, this.getRootPath().getNumComponents(), this.selectedPath, false, false, false, attrs));
        } else {
            dirList.add(new DirNodeData(p2, noFiles, this.isDirHidden(p2), parent, this.getRootPath().getNumComponents(), this.selectedPath, false, rev.isDead(), false, attrs));
        }
        ++this.nodeCount;
    }

    private void addFilePath(List<DirNodeData> dirList, Path p2, DirNodeData parent, Pair<String, String>[] attrs) throws DbException {
        FileRevision rev = this.pathExplorer.getLatestFileRevision(p2);
        if (rev != null) {
            dirList.add(new DirNodeData(p2, false, false, parent, this.getRootPath().getNumComponents(), this.selectedPath, rev.getRevision(), true, rev.isDead(), rev.isBinary(), attrs));
            ++this.nodeCount;
        }
    }

    private boolean isDirHidden(Path subdir) {
        if (this.hiddenPatterns.isEmpty()) {
            return false;
        }
        for (AntGlob glob : this.hiddenPatterns) {
            if (!glob.matches(subdir.toString())) continue;
            return true;
        }
        return false;
    }

    private boolean isPathEmptyOfFiles(Path p2) {
        boolean result = this.pathExplorer.isEmptyOfFiles(p2);
        if (result) {
            this.containsEmptyDirs = true;
        }
        return result;
    }

    @Override
    public String getRepositoryName() {
        return this.repoName;
    }

    @Override
    public boolean isHideHiddenDirs() {
        return this.hideHiddenDirs;
    }

    @Override
    public boolean isHideEmptyDirs() {
        return this.hideEmptyDirs;
    }

    @Override
    public boolean isHideDeletedFiles() {
        return this.hideDeletedFiles;
    }

    @Override
    public boolean isContainsEmptyDirs() {
        return this.containsEmptyDirs;
    }

    @Override
    public List<DirNodeData> getNodes() {
        return DirTreeDataUtils.flattenTree(this.rootNode);
    }

    @Override
    public List<DirNodeData> getParentNode() {
        if (this.parentNode == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(this.parentNode);
    }

    @Override
    public boolean isAborted() {
        return false;
    }

    @Override
    public Path getRootPath() {
        return this.rootPath;
    }

    @Override
    public Path getSelectedPath() {
        return this.selectedPath;
    }

    @Override
    public long getActualTreeBuildTime() {
        return this.actualTreeBuildTime;
    }

    @Override
    public boolean isRepoMayHide() {
        return this.repoMayHide;
    }

    @Override
    public int getNumberOfNodes() {
        return this.nodeCount;
    }

    public static interface PathExplorer {
        public PathInfo[] listSubTree(Path var1) throws DbException;

        public FileRevision getLatestFileRevision(Path var1) throws DbException;

        public boolean isEmptyOfFiles(Path var1);
    }

    public static class PathInfo
    implements Comparable<PathInfo> {
        public final Path path;
        public final boolean isFile;
        public final Pair<String, String>[] attrs;

        public PathInfo(Path path, boolean file, Pair<String, String> ... attrs) {
            this.path = path;
            this.isFile = file;
            this.attrs = attrs;
        }

        @Override
        public int compareTo(PathInfo o2) {
            return this.path.compareTo(o2.path);
        }
    }
}

