/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.changeset;

import com.atlassian.fisheye.scm.DirTreeData;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.web.PreferenceManager;
import com.cenqua.fisheye.web.RepositoryAction;
import com.cenqua.fisheye.web.WaybackSpec;
import com.cenqua.fisheye.web.changeset.ChangeSetDirTreeData;
import com.cenqua.fisheye.web.changeset.ChangeSetPageData;
import com.cenqua.fisheye.web.dirtree.AbstractLoadSubTreeAction;

public class LoadChangeSetSubTreeAction
extends AbstractLoadSubTreeAction {
    private String csid;
    protected boolean noFiles;
    protected String selectedPath;

    @Override
    protected DirTreeData makeDirTree() throws DbException {
        try {
            RepositoryHandle rep = super.getRepositoryHandle(this.repName);
            RevisionCache<? extends ChangeSet> revCache = rep.acquireEngine().getRevisionCache();
            Object cs = revCache.getChangeSet(this.csid);
            if (cs != null) {
                ChangeSetPageData cspd = new ChangeSetPageData(new WaybackSpec(), (ChangeSet)cs, null, 1, 0, revCache, PreferenceManager.getPreferences(this.request));
                return new ChangeSetDirTreeData(this.path, null, (ChangeSet)cs, cspd);
            }
            throw new RuntimeException("Changeset //" + this.repName + "/" + this.csid + " not found");
        }
        catch (RepositoryHandle.StateException e2) {
            this.errorMsg = e2.getMessage();
            return null;
        }
        catch (RepositoryAction.RepositoryPermissionException e3) {
            this.errorMsg = "You are not permitted to access the repository '" + this.repName + "'";
            return null;
        }
    }

    @Override
    @RequireSecurityToken(value=false)
    public String execute() {
        return super.execute();
    }

    public void setCsid(String csid) {
        this.csid = csid;
    }

    public Boolean getNoFiles() {
        return this.noFiles;
    }

    public void setNoFiles(Boolean noFiles) {
        this.noFiles = noFiles;
    }

    public void setSelectedPath(String selectedPath) {
        this.selectedPath = selectedPath;
    }
}

