/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.changeset;

import com.atlassian.crucible.filters.CrucibleFilter;
import com.atlassian.fisheye.Visitor;
import com.cenqua.crucible.revision.source.Source;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.ChangesetRevision;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.util.Pair;
import com.cenqua.fisheye.util.Timer;
import com.cenqua.fisheye.web.CookiePreferences;
import com.cenqua.fisheye.web.WaybackSpec;
import com.cenqua.fisheye.web.paging.PagingCalculator;
import com.cenqua.fisheye.web.paging.TotalCountAwarePagingCalculator;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ChangeSetPageData {
    private final ChangeSet changeSet;
    private final CookiePreferences userPrefs;
    private final int currentPage;
    private final WaybackSpec wbSpec;
    private final int selectedIndex;
    private final IntList diffableIdsOnCurrentPage;
    private final List<PathAndRevId> allChangesetFileRevisions;
    private final PagingCalculator pagingCalculator;
    private final List<ChangesetRevision> changesetRevisionsOnCurrentPage;

    public ChangeSetPageData(WaybackSpec wbSpec, ChangeSet changeSet, String currentPagePath, int currentPage, int currentIndex, RevisionCache revCache, CookiePreferences userPrefs) throws DbException {
        this.wbSpec = wbSpec;
        this.changeSet = changeSet;
        this.userPrefs = userPrefs;
        this.allChangesetFileRevisions = new ArrayList<PathAndRevId>();
        Timer t2 = new Timer("Loading and sorting changeset revisions");
        changeSet.visitRevisions(new Visitor<FileRevision>(){

            @Override
            public void visit(FileRevision rev) {
                ChangeSetPageData.this.allChangesetFileRevisions.add(new PathAndRevId(rev.getRevInfoKey().getPath().getPath(), rev.getRevID()));
            }
        });
        Collections.sort(this.allChangesetFileRevisions);
        this.pagingCalculator = TotalCountAwarePagingCalculator.getPagingCalculator(currentPage, this.allChangesetFileRevisions.size(), 1);
        this.diffableIdsOnCurrentPage = new IntArrayList();
        ArrayList<FileRevision> revs = new ArrayList<FileRevision>();
        for (PathAndRevId info : this.allChangesetFileRevisions.subList(this.pagingCalculator.getCurrentPageStart(), this.pagingCalculator.getCurrentPageEnd())) {
            FileRevision rev = revCache.getFileRevision(info.revID);
            revs.add(rev);
            if (rev.isDead() || rev.isBinaryOrOversize() || rev.isDir()) continue;
            this.diffableIdsOnCurrentPage.add(rev.getRevID());
        }
        this.changesetRevisionsOnCurrentPage = revCache.getChangesetRevisions(changeSet, revs);
        t2.end();
        if (currentPagePath != null) {
            Pair<Integer, Integer> pageAndIndex = this.getPageAndIndex(currentPagePath);
            this.currentPage = pageAndIndex.getFirst();
            this.selectedIndex = pageAndIndex.getSecond();
        } else {
            this.currentPage = currentPage;
            this.selectedIndex = currentIndex;
        }
    }

    public Pair<Integer, Integer> getPageAndIndex(String path) {
        int location = Collections.binarySearch(this.allChangesetFileRevisions, new PathAndRevId(path, 0));
        if (location < 0) {
            location = -(location + 1);
        }
        return Pair.newInstance(location + 1, 1);
    }

    public int getNoOfPages() throws DbException {
        return this.allChangesetFileRevisions.size();
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public Iterator<ChangesetRevision> getChangesetRevisions() {
        return this.changesetRevisionsOnCurrentPage.iterator();
    }

    public Collection<Integer> getDiffableRevIds() {
        return this.diffableIdsOnCurrentPage;
    }

    public String getRepname() {
        return this.changeSet.getRepName();
    }

    public Source getSource() {
        return CrucibleFilter.getSource(this.getRepname());
    }

    public WaybackSpec getWbSpec() {
        return this.wbSpec;
    }

    public CookiePreferences getUserPrefs() {
        return this.userPrefs;
    }

    private static class PathAndRevId
    implements Comparable<PathAndRevId> {
        private final String path;
        private final int revID;

        private PathAndRevId(String path, int revID) {
            this.path = path;
            this.revID = revID;
        }

        public String getPath() {
            return this.path;
        }

        @Override
        public int compareTo(PathAndRevId o2) {
            return this.getPath().compareTo(o2.getPath());
        }
    }
}

