/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.changeset;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.util.Pair;
import com.cenqua.fisheye.web.changeset.ChangeSetPageData;
import com.cenqua.fisheye.web.dirtree.AbstractLazyDirTree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class ChangeSetDirTreeData
extends AbstractLazyDirTree {
    public ChangeSetDirTreeData(String rootPath, String selectedPath, ChangeSet changeSet, ChangeSetPageData cspd) throws DbException {
        super(new ChangeSetPathExplorer(changeSet, cspd), changeSet.getRepName(), new Path(rootPath), selectedPath == null ? null : new Path(selectedPath), false, 200L, false, false, false, Collections.emptyList(), null);
    }

    private static class ChangeSetPathExplorer
    implements AbstractLazyDirTree.PathExplorer {
        private Map<Path, FileRevision> latestRevision;
        private final ChangeSet changeSet;
        private final ChangeSetPageData cspd;

        public ChangeSetPathExplorer(ChangeSet changeSet, ChangeSetPageData cspd) {
            this.changeSet = changeSet;
            this.cspd = cspd;
            this.latestRevision = new HashMap<Path, FileRevision>();
        }

        @Override
        public AbstractLazyDirTree.PathInfo[] listSubTree(Path parent) throws DbException {
            ArrayList<AbstractLazyDirTree.PathInfo> children = new ArrayList<AbstractLazyDirTree.PathInfo>();
            HashSet<String> recordedPaths = new HashSet<String>();
            for (FileRevision fileRevision : this.changeSet.getFileRevisions()) {
                if (parent.isAncestor(fileRevision.getPath())) {
                    String childComponent = fileRevision.getPath().getComponent(parent.getNumComponents());
                    if (!recordedPaths.contains(childComponent)) {
                        recordedPaths.add(childComponent);
                        Path childPath = new Path(parent, childComponent);
                        boolean isFile = false;
                        if (childPath.equals(fileRevision.getPath())) {
                            this.latestRevision.put(fileRevision.getPath(), fileRevision);
                            isFile = fileRevision.isFile();
                        }
                        Pair<Integer, Integer> pageAndIndex = this.cspd.getPageAndIndex(childPath.getPath());
                        children.add(new AbstractLazyDirTree.PathInfo(childPath, isFile, Pair.newInstance("page", pageAndIndex.getFirst().toString()), Pair.newInstance("index", pageAndIndex.getSecond().toString())));
                        continue;
                    }
                    if (fileRevision.getPath().getNumComponents() != parent.getNumComponents() + 1) continue;
                    this.latestRevision.put(fileRevision.getPath(), fileRevision);
                    continue;
                }
                if (!parent.equals(fileRevision.getPath())) continue;
                this.latestRevision.put(parent, fileRevision);
            }
            Collections.sort(children);
            return children.toArray(new AbstractLazyDirTree.PathInfo[children.size()]);
        }

        @Override
        public FileRevision getLatestFileRevision(Path p2) throws DbException {
            return this.latestRevision.get(p2);
        }

        @Override
        public boolean isEmptyOfFiles(Path p2) {
            return false;
        }
    }
}

