/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.interceptors;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.web.admin.util.AdminBasicAuth;
import com.opensymphony.webwork.ServletActionContext;
import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.interceptor.AroundInterceptor;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class LoginInterceptor
extends AroundInterceptor {
    public static final String SESSION_KEY = LoginInterceptor.class.getName() + ".user";
    public static final String SUCCESS_URL_KEY = LoginInterceptor.class.getName() + ".url";

    protected void after(ActionInvocation actionInvocation, String s2) throws Exception {
    }

    protected void before(ActionInvocation actionInvocation) throws Exception {
    }

    public String intercept(ActionInvocation invocation) throws Exception {
        if (!LoginInterceptor.checkLogin(ServletActionContext.getRequest())) {
            return "login";
        }
        return invocation.invoke();
    }

    public static boolean isAdminUser(HttpServletRequest request) throws DbException {
        if (AdminBasicAuth.checkRequest(request)) {
            return true;
        }
        HttpSession session = request.getSession(false);
        Object user = session == null ? null : session.getAttribute(SESSION_KEY);
        return user == SESSION_KEY || AppConfig.getsConfig().getUserManager().hasSysAdminPrivileges(request);
    }

    public static boolean isChangePasswordEnabled(HttpServletRequest request) throws DbException {
        UserManager userManager = AppConfig.getsConfig().getUserManager();
        if (userManager.isPasswordlessAuthenticationEnabled()) {
            return false;
        }
        UserLogin user = userManager.getCurrentUser(request);
        return user != null && userManager.canUpdateUser(user.getUsername());
    }

    public static boolean checkLogin(HttpServletRequest request) throws DbException {
        if (LoginInterceptor.isAdminUser(request)) {
            return true;
        }
        StringBuffer successURL = request.getRequestURL();
        String query = request.getQueryString();
        if (query != null) {
            successURL.append("?").append(query);
        }
        HttpSession session = request.getSession(true);
        session.setAttribute(SUCCESS_URL_KEY, (Object)successURL.toString());
        return false;
    }
}

