/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions.user;

import com.atlassian.fecru.user.FecruUser;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.web.admin.actions.user.BaseUserAdminAction;

public class UserRenameAdminAction
extends BaseUserAdminAction {
    private String uname;
    private String newname;

    public String getNewname() {
        return this.newname;
    }

    public void setNewname(String newname) {
        this.newname = newname;
    }

    public String getUname() {
        return this.uname;
    }

    public void setUname(String uname) {
        this.uname = uname;
    }

    @RequireSecurityToken(value=false)
    public String doDefault() throws Exception {
        this.assertUserName(this.uname);
        this.newname = this.uname;
        return "success";
    }

    @Override
    public String execute() throws Exception {
        this.assertUserName(this.uname);
        UserManager um = this.getUserManager();
        try {
            um.renameUser(this.uname, this.newname);
        }
        catch (Exception e2) {
            this.addActionErrorAndLogWarning("The user could not be updated.", e2);
            return "input";
        }
        return "success";
    }

    public void validate() {
        if (this.hasErrors()) {
            return;
        }
        UserManager um = this.getUserManager();
        try {
            if (this.newname.equals(this.uname)) {
                this.addFieldError("newname", "New username must be different from existing name");
                return;
            }
            FecruUser existingUser = um.getUser(this.newname);
            if (existingUser != null) {
                this.addFieldError("newname", "This username is already in use");
            }
            if (!um.isUserNameValid(this.newname)) {
                this.addFieldError("newname", "Username can only contain alphanumeric, underscore, at ('@'), dot, dash or backslash");
            }
        }
        catch (Exception e2) {
            this.addActionErrorAndLogWarning("Error validating user.", "problem changing user", e2);
        }
    }
}

