/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions.user;

import com.atlassian.fecru.user.FecruUser;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.fisheye.model.CommitterUserMapping;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.web.admin.actions.BaseAdminAction;
import com.cenqua.fisheye.web.util.RepositoryUtil;
import com.opensymphony.webwork.interceptor.ServletRequestAware;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class UserMappingAdminAction
extends BaseAdminAction
implements ServletRequestAware {
    HttpServletRequest request;

    @Override
    public void setServletRequest(HttpServletRequest request) {
        this.request = request;
    }

    public Set<String> getUsers() throws DbException {
        HashSet<String> users = new HashSet<String>();
        List<CommitterUserMapping> mappings = this.getUserMappingManager().findAll();
        for (CommitterUserMapping mapping : mappings) {
            users.add(mapping.getUserName());
        }
        return users;
    }

    public Set<String> getRepositories(String user) throws DbException {
        return this.getUserMappingManager().getExplicitCommittersForUser(user).keySet();
    }

    public List<RepositoryHandle> getRepositories() {
        return RepositoryUtil.repositories(this.request);
    }

    public List<String> getCommitters(String user, String rep) throws DbException {
        return this.getUserMappingManager().getExplicitCommittersForUserInRep(rep, user);
    }

    public String getDisplayName(String user) {
        FecruUser feUser = this.getUserManager().getLicensedUser(user);
        if (feUser != null) {
            return feUser.getDisplayName();
        }
        return user;
    }

    @RequireSecurityToken(value=false)
    public String doDefault() throws Exception {
        return super.doDefault();
    }
}

