/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions.user;

import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.user.permissions.EffectiveUserPermissionService;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.fisheye.web.admin.actions.user.BaseUserAdminAction;
import com.cenqua.fisheye.web.profile.actions.ExternalUserHelper;
import com.google.common.base.Strings;
import java.util.List;
import javax.annotation.Resource;

public class UserEditAdminAction
extends BaseUserAdminAction {
    @Resource
    EffectiveUserPermissionService effectiveUserPermissionService;
    private String uname;
    private boolean newlyAdded = false;
    private ExternalUserHelper externalUserHelper;
    private String displayName;
    private String userEmail;
    private boolean admin;
    private boolean isFisheyeUser;
    private boolean isCrucibleUser;

    public ExternalUserHelper getExternalUserHelper() {
        if (this.externalUserHelper == null) {
            this.externalUserHelper = new ExternalUserHelper(this.uname, this.userManager);
        }
        return this.externalUserHelper;
    }

    public String getUname() {
        return this.uname;
    }

    public void setUname(String uname) {
        this.uname = uname;
    }

    @RequireSecurityToken(value=false)
    public String doDefault() throws Exception {
        this.assertUserName(this.uname);
        FecruUser user = this.userManager.getEnabledUser(this.uname).orElseThrow(() -> new IllegalStateException("User does not exist"));
        this.setUserDisplayName(user.getDisplayName());
        this.setUserEmail(user.getEmail());
        this.admin = this.userManager.hasSysAdminPrivileges(this.uname);
        this.isFisheyeUser = this.effectiveUserPermissionService.canUserAccessFisheye(user.getUsername());
        this.isCrucibleUser = this.effectiveUserPermissionService.canUserAccessCrucible(user.getUsername());
        return "success";
    }

    @Override
    public String execute() throws Exception {
        this.assertUserName(this.uname);
        if (this.userManager.getEnabledUser(this.uname) == null) {
            this.addActionError("The user " + this.uname + "does not exist");
            return "input";
        }
        try {
            this.userManager.updateUser(this.uname, this.getUserDisplayName(), this.getUserEmail());
        }
        catch (Exception e2) {
            this.addActionErrorAndLogWarning("The user could not be updated.", e2);
            return "input";
        }
        return "success";
    }

    public void validate() {
        this.getExternalUserHelper().validateUserFields(this, this.getUserEmail(), this.getUserDisplayName());
        if (this.hasErrors()) {
            return;
        }
        try {
            String existingUser;
            if (!Strings.isNullOrEmpty((String)this.getUserEmail()) && (existingUser = this.userManager.getUsernameByEmail(this.getUserEmail())) != null && !existingUser.equals(this.uname)) {
                this.addFieldError("userEmail", "Email address must be unique, currently used by " + existingUser);
            }
        }
        catch (Exception e2) {
            this.addActionErrorAndLogWarning("The user could not be validated.", e2);
        }
    }

    public boolean isNewlyAdded() {
        return this.newlyAdded;
    }

    public void setNewlyAdded(boolean newlyAdded) {
        this.newlyAdded = newlyAdded;
    }

    public boolean isAdmin() {
        return this.admin;
    }

    public String getUserDisplayName() {
        return this.displayName;
    }

    public void setUserDisplayName(String displayName) {
        this.displayName = displayName.trim();
    }

    public String getUserEmail() {
        return this.userEmail;
    }

    public void setUserEmail(String email) {
        this.userEmail = email == null ? "" : email.trim();
    }

    public List<String> getUserGroups() {
        return this.getUserGroups(this.uname);
    }

    public boolean isFisheyeUser() {
        return this.isFisheyeUser;
    }

    public boolean isCrucibleUser() {
        return this.isCrucibleUser;
    }

    public boolean isUnlicensedUser() {
        return !this.isFisheyeUser && !this.isCrucibleUser;
    }
}

