/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions.user;

import com.atlassian.fecru.user.FecruUser;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.view.reviewfilters.ReviewFilters;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.web.admin.actions.user.UserAdminAction;
import org.springframework.beans.factory.annotation.Autowired;

public class UserDeleteAction
extends UserAdminAction {
    private String uname;
    private UserManager userManager;
    private ReviewManager reviewManager;

    @Autowired
    public void setReviewManager(ReviewManager reviewManager) {
        this.reviewManager = reviewManager;
    }

    @Autowired
    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public String getUname() {
        return this.uname;
    }

    public void setUname(String uname) {
        this.uname = uname;
    }

    @RequireSecurityToken(value=false)
    public String doDefault() throws Exception {
        return super.doDefault();
    }

    @Override
    public String execute() throws Exception {
        String result = "success";
        try {
            boolean userDeleted = this.userManager.deleteUserAndRemoveCommitterMappings(this.uname);
            if (userDeleted) {
                this.addActionMessage("User '" + this.uname + "' successfully deleted.");
            } else {
                this.addActionError("User '" + this.uname + "' was not deleted.");
                result = "error";
            }
        }
        catch (Exception e2) {
            this.addActionErrorAndLogWarning("Error deleting user.", e2);
            result = "error";
        }
        super.execute();
        return result;
    }

    public int getNumActiveReviews() {
        FecruUser user = this.userManager.getUser(this.uname);
        ReviewFilters f2 = new ReviewFilters(user);
        return this.reviewManager.getMatchingReviewIds(f2.getFilterDefByKey(ReviewFilters.FilterKey.ACTIVE_PARTICIPANT), null).size();
    }
}

