/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions.user;

import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.web.admin.actions.user.BaseUserAdminAction;
import com.cenqua.fisheye.web.admin.util.PasswordActionUtils;

public class UserChangePasswordAdminAction
extends BaseUserAdminAction {
    private String password1;
    private String password2;
    private String uname;

    public String getUname() {
        return this.uname;
    }

    public void setUname(String uname) {
        this.uname = uname;
    }

    public String getPassword1() {
        return this.password1;
    }

    public void setPassword1(String password1) {
        this.password1 = password1;
    }

    public String getPassword2() {
        return this.password2;
    }

    public void setPassword2(String password2) {
        this.password2 = password2;
    }

    @RequireSecurityToken(value=false)
    public String doDefault() throws Exception {
        this.assertUserName(this.uname);
        return super.doDefault();
    }

    @Override
    public String execute() {
        this.assertUserName(this.uname);
        try {
            UserManager um = this.getUserManager();
            if (um.getEnabledUser(this.uname) != null) {
                um.changePassword(this.uname, this.password1);
            }
            return "success";
        }
        catch (Exception e2) {
            this.addActionErrorAndLogWarning("The user could not be updated.", "problem changing password", e2);
            return "input";
        }
    }

    public void validate() {
        if (this.hasErrors()) {
            return;
        }
        PasswordActionUtils.checkPassword(this, this.password1, this.password2);
    }
}

