/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions.user;

import com.atlassian.fecru.license.LicenseManager;
import com.atlassian.fecru.page.Page;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.user.UserSearchCriteria;
import com.cenqua.fisheye.web.admin.actions.BaseAdminAction;
import com.cenqua.fisheye.web.admin.actions.user.BulkEditType;
import com.cenqua.fisheye.web.paging.PagingCalculator;
import com.cenqua.fisheye.web.paging.PreviousNextPagingCalculator;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.annotation.Resource;

public class UserAdminAction
extends BaseAdminAction {
    @Resource
    private UserManager userManager;
    @Resource
    private LicenseManager licenseManager;
    private final RootConfig rootConfig;
    private List<UserData> displayUsers = new LinkedList<UserData>();
    private String filterGroup;
    private String filterString;
    private PreviousNextPagingCalculator pagingCalculator;

    public UserAdminAction() {
        this(AppConfig.getsConfig());
    }

    public UserAdminAction(RootConfig rootConfig) {
        this.rootConfig = rootConfig;
    }

    public String getFilterGroup() {
        return this.filterGroup;
    }

    public void setFilterGroup(String filterGroup) {
        this.filterGroup = filterGroup;
    }

    public String getFilterString() {
        return this.filterString;
    }

    public void setFilterString(String filterString) {
        this.filterString = filterString;
    }

    public BulkEditType[] getBulkEditTypes() {
        if (this.rootConfig.isFishEyeOnly() || this.rootConfig.isCrucibleOnly()) {
            return (BulkEditType[])ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)Lists.newArrayList((Object[])BulkEditType.values()), (Predicate)new Predicate<BulkEditType>(){

                public boolean apply(BulkEditType editType) {
                    return !editType.getRequiresBothLicences();
                }
            })).toArray((Object[])new BulkEditType[0]);
        }
        return BulkEditType.values();
    }

    public PagingCalculator getPagingCalculator() {
        return this.pagingCalculator;
    }

    @Override
    @RequireSecurityToken(value=false)
    public String execute() throws Exception {
        this.pagingCalculator = new PreviousNextPagingCalculator(this.getRequest());
        Iterable<FecruUser> users = this.isFilteringByGroup() ? this.doGroupUsers() : this.doFilteredUsers();
        for (FecruUser user : users) {
            this.displayUsers.add(new UserData(user));
        }
        return "success";
    }

    private Iterable<FecruUser> doGroupUsers() {
        List<FecruUser> usersInGroup = this.groupMembershipManager.getUsersInGroup(this.filterGroup);
        List filteredUsers = usersInGroup.stream().filter(user -> this.matchesFilter((FecruUser)user)).collect(Collectors.toList());
        this.pagingCalculator.setLastPage(this.pagingCalculator.getCurrentPageEnd() >= filteredUsers.size());
        return filteredUsers.subList(this.pagingCalculator.getCurrentPageStart(), Math.min(this.pagingCalculator.getCurrentPageEnd(), filteredUsers.size()));
    }

    private Iterable<FecruUser> doFilteredUsers() {
        UserSearchCriteria criteria = this.isFilteringByUser() ? UserSearchCriteria.create().named(this.filterString) : UserSearchCriteria.create();
        Page<FecruUser> usersPage = this.userManager.searchUsers(criteria, this.pagingCalculator.createPageRequest());
        this.pagingCalculator.setLastPage(usersPage.isLastPage());
        return usersPage.getValues();
    }

    public List<UserData> getDisplayUsers() {
        return this.displayUsers;
    }

    private boolean matchesFilter(FecruUser user) {
        return !this.isFilteringByUser() || this.matchesFilterString(user.getEmail()) || this.matchesFilterString(user.getUsername()) || this.matchesFilterString(user.getDisplayName());
    }

    private boolean isFilteringByGroup() {
        return !Strings.isNullOrEmpty((String)this.filterGroup);
    }

    private boolean isFilteringByUser() {
        return !Strings.isNullOrEmpty((String)this.filterString);
    }

    public int getExcessFEUserCount() {
        return this.licenseManager.getExcessFEUsers();
    }

    public int getExcessCruUserCount() {
        return this.licenseManager.getExcessCruUsers();
    }

    private boolean matchesFilterString(String value) {
        return value != null && value.toLowerCase(Locale.US).contains(this.filterString.toLowerCase(Locale.US));
    }

    private static class UserData {
        private final String username;
        private final String email;
        private final String displayName;

        public UserData(FecruUser user) {
            this.username = user.getUsername();
            this.email = user.getEmail();
            this.displayName = user.getDisplayName();
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getUsername() {
            return this.username;
        }

        public String getEmail() {
            return this.email;
        }
    }
}

