/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions.user;

import com.atlassian.fecru.user.FecruUser;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.crucible.model.managers.InviteManager;
import com.cenqua.fisheye.LicensePolicyException;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.user.UserUtils;
import com.cenqua.fisheye.web.admin.actions.user.BaseUserAdminAction;
import com.cenqua.fisheye.web.admin.util.PasswordActionUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;

public class UserAddAdminAction
extends BaseUserAdminAction {
    private String username;
    private String password1;
    private String password2;
    private String email;
    private String displayName;

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword1() {
        return this.password1;
    }

    public void setPassword1(String password1) {
        this.password1 = password1;
    }

    public String getPassword2() {
        return this.password2;
    }

    public void setPassword2(String password2) {
        this.password2 = password2;
    }

    @RequireSecurityToken(value=false)
    public String doDefault() throws Exception {
        return super.doDefault();
    }

    @Override
    public String execute() {
        try {
            UserManager um = this.getUserManager();
            FecruUser fecruUser = um.addUser(this.username, this.displayName, this.email, this.password1, true);
            this.deleteCrucibleInviteUser(fecruUser);
            return "success";
        }
        catch (LicensePolicyException e2) {
            Logs.APP_LOG.warn((Object)"problem adding user", (Throwable)e2);
            this.addActionError("The user could not be created: " + e2.getMessage());
            return "input";
        }
        catch (Exception e3) {
            this.addActionErrorAndLogWarning("The user could not be created.", e3);
            return "input";
        }
    }

    @VisibleForTesting
    void deleteCrucibleInviteUser(FecruUser user) {
        InviteManager.deleteCrucibleInviteUser(user.getEmail(), user);
    }

    public void validate() {
        if (this.hasErrors()) {
            return;
        }
        UserManager um = this.getUserManager();
        this.username = UserUtils.sanitize(this.username);
        try {
            String existingUser;
            if (um.existsEnabledUser(this.username)) {
                this.addFieldError("username", "An user with that name already exists");
            }
            if (!Strings.isNullOrEmpty((String)this.email) && (existingUser = um.getUsernameByEmail(this.email)) != null) {
                this.addFieldError("userEmail", "The user's email address must be unique, but it is currently used by " + existingUser);
            }
            if (!um.isUserNameValid(this.username)) {
                this.addFieldError("username", "Username can only contain alphanumeric, underscore, at ('@'), dot, dash or backslash");
            }
        }
        catch (Exception e2) {
            this.addActionErrorAndLogWarning("Failed validating user.", "problem adding user", e2);
        }
        if (!this.isPasswordlessAuthenticationEnabled()) {
            PasswordActionUtils.checkPassword(this, this.password1, this.password2);
        } else {
            this.password1 = null;
            this.password2 = null;
        }
    }

    public boolean isPasswordlessAuthenticationEnabled() {
        return this.userManager.isPasswordlessAuthenticationEnabled();
    }

    public String getUserEmail() {
        return this.email;
    }

    public void setUserEmail(String email) {
        this.email = email;
    }

    public String getUserDisplayName() {
        return this.displayName;
    }

    public void setUserDisplayName(String displayName) {
        this.displayName = displayName;
    }
}

