/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions.user;

import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config1.SecurityType;
import com.cenqua.fisheye.web.admin.actions.BaseAdminAction;
import com.cenqua.fisheye.web.admin.actions.sec.EditEmailVisibilityAction;
import com.cenqua.fisheye.web.security.RestApiKeyManager;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;

public class SecurityAdminAction
extends BaseAdminAction {
    public static final String ULIST_ANON = "ANON";
    public static final String ULIST_LOGGED_IN = "LOGGEDIN";
    public static final String ULIST_DISABLED = "DISABLE";
    private String userListVisibilityOption;
    @Resource
    private RestApiKeyManager restApiKeyManager;
    private static final Map<String, String> USER_VISIBILITY_OPTS = new HashMap<String, String>();

    public RestApiKeyManager getRestApiKeyManager() {
        return this.restApiKeyManager;
    }

    public Map<Integer, String> getEmailVisibilityOptions() {
        return EditEmailVisibilityAction.getEmailVisibilityMap();
    }

    public Integer getEmailVisibility() {
        return EditEmailVisibilityAction.getEmailVisibility();
    }

    public boolean getCaptchaEnabled() {
        return this.getSecurityConfig().getEnableLoginCaptcha();
    }

    public Long getMaxLogins() {
        return this.getSecurityConfig().getMaxLoginFailures().longValue();
    }

    private SecurityType getSecurityConfig() {
        return AppConfig.getsConfig().getConfig().getSecurity();
    }

    public Map<String, String> getUserListVisibilityOptions() {
        return USER_VISIBILITY_OPTS;
    }

    public void setUserListVisibility(String option) {
        this.userListVisibilityOption = option;
    }

    public String getUserListVisibility() {
        if (!this.getCfg().getSecurity().getEnableUserLists()) {
            return ULIST_DISABLED;
        }
        if (this.getCfg().getSecurity().getAllowUserListsAnon()) {
            return ULIST_ANON;
        }
        return ULIST_LOGGED_IN;
    }

    @RequireSecurityToken(value=false)
    public String doDefault() throws Exception {
        this.userListVisibilityOption = this.userListVisibilityOption != null ? this.userListVisibilityOption.toUpperCase() : "";
        return "success";
    }

    @Override
    public String execute() throws Exception {
        if (ULIST_ANON.equals(this.userListVisibilityOption)) {
            this.getCfg().getSecurity().setAllowUserListsAnon(true);
            this.getCfg().getSecurity().setEnableUserLists(true);
        } else if (ULIST_LOGGED_IN.equals(this.userListVisibilityOption)) {
            this.getCfg().getSecurity().setAllowUserListsAnon(false);
            this.getCfg().getSecurity().setEnableUserLists(true);
        } else if (ULIST_DISABLED.equals(this.userListVisibilityOption)) {
            this.getCfg().getSecurity().setAllowUserListsAnon(false);
            this.getCfg().getSecurity().setEnableUserLists(false);
        }
        AppConfig.getsConfig().saveConfig();
        return "success";
    }

    static {
        USER_VISIBILITY_OPTS.put(ULIST_ANON, "Public");
        USER_VISIBILITY_OPTS.put(ULIST_LOGGED_IN, "Visible to logged in users only");
        USER_VISIBILITY_OPTS.put(ULIST_DISABLED, "Hidden");
    }
}

