/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions.user;

import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.fisheye.user.GroupInfo;
import com.cenqua.fisheye.web.admin.actions.user.GroupAdminAction;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

public class GroupEditAction
extends GroupAdminAction {
    private GroupAdminAction.GroupData groupData;
    private String group;
    private boolean isAdmin = false;
    private List<String> addUsers = Collections.emptyList();
    private List<String> removeUsers = Collections.emptyList();
    private List<String> groupMembers;
    private Set<String> nonGroupMembers;
    private String addUser;
    private String removeUser;
    private String saveGroup;

    public GroupAdminAction.GroupData getGroupData() {
        GroupInfo info = this.getGroupInfoMap().get(this.group);
        if (info != null) {
            this.groupData = new GroupAdminAction.GroupData(info, this.groupMembershipManager, this.userManager);
        }
        return this.groupData;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public boolean getIsAdmin() {
        return this.isAdmin;
    }

    public void setIsAdmin(boolean isAdmin) {
        this.isAdmin = isAdmin;
    }

    public void setAddUsers(String[] addUsers) {
        this.addUsers = Arrays.asList(addUsers);
        this.addUsers.removeAll(this.groupMembers);
    }

    public void setRemoveUsers(String[] removeUsers) {
        this.removeUsers = Arrays.asList(removeUsers);
        this.removeUsers.removeAll(this.nonGroupMembers);
    }

    @RequireSecurityToken(value=false)
    public String doDefault() throws Exception {
        this.validateGroup();
        return "success";
    }

    private boolean validateGroup() {
        if (this.group == null) {
            return false;
        }
        if (!this.isExistingGroup()) {
            this.addActionError("Group " + this.group + " was not found");
            return false;
        }
        return true;
    }

    @Override
    public String execute() throws Exception {
        if (!this.validateGroup()) {
            return "success";
        }
        try {
            if (!Strings.isNullOrEmpty((String)this.addUser)) {
                for (String user : this.addUsers) {
                    this.groupMembershipManager.addUserToGroup(this.group, user);
                }
            }
            if (!Strings.isNullOrEmpty((String)this.removeUser)) {
                for (String user : this.removeUsers) {
                    this.groupMembershipManager.removeUserFromGroup(this.group, user);
                }
            }
            if (!Strings.isNullOrEmpty((String)this.saveGroup)) {
                if (this.isAdmin) {
                    this.adminUserConfig.addGroup(this.group);
                } else {
                    this.adminUserConfig.removeGroup(this.group);
                }
                this.adminUserConfig.save();
            }
        }
        catch (Exception e2) {
            this.addActionErrorAndLogWarning("Failed updating group memberships.", e2);
        }
        return "success";
    }

    private boolean isExistingGroup() {
        return this.getGroupData() != null;
    }

    public List<String> getGroupMembers() {
        if (this.groupMembers == null) {
            this.groupMembers = this.getGroupData().getUsers();
        }
        return this.groupMembers;
    }

    public Set<String> getNonGroupMembers() {
        if (this.nonGroupMembers == null) {
            this.nonGroupMembers = Sets.newTreeSet((Comparator)String.CASE_INSENSITIVE_ORDER);
            this.nonGroupMembers.addAll(this.getUserManager().getAllEnabledUsernames());
            this.nonGroupMembers.removeAll(this.getGroupMembers());
        }
        return this.nonGroupMembers;
    }

    public String getSaveGroup() {
        return this.saveGroup;
    }

    public void setSaveGroup(String saveGroup) {
        this.saveGroup = saveGroup;
    }

    public String getRemoveUser() {
        return this.removeUser;
    }

    public void setRemoveUser(String removeUser) {
        this.removeUser = removeUser;
    }

    public String getAddUser() {
        return this.addUser;
    }

    public void setAddUser(String addUser) {
        this.addUser = addUser;
    }
}

