/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions.user;

import com.atlassian.fecru.page.Page;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.user.GroupInfo;
import com.cenqua.fisheye.user.GroupMembershipManager;
import com.cenqua.fisheye.user.GroupSearchCriteria;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.web.admin.actions.BaseAdminAction;
import com.cenqua.fisheye.web.paging.PreviousNextPagingCalculator;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.stream.Collectors;

public class GroupAdminAction
extends BaseAdminAction {
    private List<GroupData> groupData;
    private PreviousNextPagingCalculator pagingCalculator;
    private String filterString;

    public void initData() {
        GroupSearchCriteria groupSearchCriteria = GroupSearchCriteria.create().prefix(this.getFilterString());
        this.pagingCalculator = new PreviousNextPagingCalculator(this.getRequest());
        Page<GroupInfo> groupInfoPage = this.getUserManager().searchGroups(groupSearchCriteria, this.pagingCalculator.createPageRequest());
        this.pagingCalculator.setLastPage(groupInfoPage.isLastPage());
        this.groupData = ImmutableList.copyOf((Iterable)groupInfoPage.transform(gi -> new GroupData((GroupInfo)gi, this.groupMembershipManager, this.userManager)).getValues());
    }

    public List<GroupData> getGroupDataList() {
        if (this.groupData == null) {
            this.initData();
        }
        return this.groupData;
    }

    public PreviousNextPagingCalculator getPagingCalculator() {
        if (this.pagingCalculator == null) {
            this.initData();
        }
        return this.pagingCalculator;
    }

    public String getFilterString() {
        return this.filterString;
    }

    public void setFilterString(String filterString) {
        this.filterString = filterString;
    }

    @Override
    @RequireSecurityToken(value=false)
    public String execute() throws Exception {
        return super.execute();
    }

    public static class GroupData {
        private final GroupInfo info;
        private final GroupMembershipManager groupMembershipManager;
        private final UserManager userManager;
        private List<String> users;

        public GroupData(GroupInfo info, GroupMembershipManager groupMembershipManager, UserManager userManager) {
            this.info = info;
            this.groupMembershipManager = groupMembershipManager;
            this.userManager = userManager;
        }

        public GroupInfo getInfo() {
            return this.info;
        }

        public List<String> getUsers() {
            if (this.users == null) {
                try {
                    this.users = this.groupMembershipManager.getUsersInGroup(this.info.getName()).stream().map(user -> user.getUsername()).collect(Collectors.toList());
                }
                catch (Exception e2) {
                    Logs.APP_LOG.warn((Object)("problem retrieving users from group " + this.info.getName()), (Throwable)e2);
                }
            }
            return this.users;
        }

        public int getNumUsers() {
            if (this.users == null) {
                this.getUsers();
            }
            return this.users == null ? 0 : this.users.size();
        }

        public boolean getAdmin() {
            return this.userManager.isAdminGroup(this.info.getName());
        }
    }
}

