/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions.user;

import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.web.admin.actions.BaseAdminAction;
import com.google.common.base.Strings;

public class GroupAddAction
extends BaseAdminAction {
    private String groupname;

    public String getGroupname() {
        return this.groupname;
    }

    public void setGroupname(String groupname) {
        this.groupname = groupname;
    }

    @RequireSecurityToken(value=false)
    public String doDefault() throws Exception {
        return super.doDefault();
    }

    @Override
    public String execute() {
        try {
            this.userManager.addGroup(this.groupname);
            return "success";
        }
        catch (Exception e2) {
            this.addActionErrorAndLogWarning("Error creating group.", e2);
            return "input";
        }
    }

    public void validate() {
        if (this.hasErrors()) {
            return;
        }
        if (Strings.isNullOrEmpty((String)this.groupname)) {
            this.addFieldError("groupname", "Name required");
        } else {
            UserManager um = this.getUserManager();
            if (!um.isGroupNameValid(this.groupname)) {
                this.addFieldError("groupname", "Group name can only contain alphanumeric, underscore, at ('@'), dot, dash or backslash");
            }
            try {
                if (um.groupExists(this.groupname)) {
                    this.addFieldError("groupname", "Group already exists");
                }
            }
            catch (Exception e2) {
                this.addActionErrorAndLogWarning("Failed adding group.", e2);
            }
        }
    }
}

