/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions.user;

import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.model.CommitterUserMapping;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.util.Disposer;
import com.cenqua.fisheye.web.admin.actions.user.BaseUserAdminAction;
import com.cenqua.fisheye.web.util.RepositoryUtil;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.opensymphony.webwork.interceptor.ServletRequestAware;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class EditUserMappingAdminAction
extends BaseUserAdminAction
implements ServletRequestAware {
    private String newCommitterName;
    private String newUserName;
    private String oldUserName;
    private String oldCommitterName;
    private String oldRepositoryName;
    private String newRepositoryName;
    private HttpServletRequest request;

    public String getOldRepositoryName() {
        return this.oldRepositoryName;
    }

    public void setOldRepositoryName(String oldRepositoryName) {
        this.oldRepositoryName = oldRepositoryName;
    }

    public String getNewRepositoryName() {
        if (Strings.isNullOrEmpty((String)this.newRepositoryName)) {
            return this.oldRepositoryName;
        }
        return this.newRepositoryName;
    }

    public void setNewRepositoryName(String newRepositoryName) {
        this.newRepositoryName = newRepositoryName;
    }

    public String getNewCommitterName() {
        return this.newCommitterName;
    }

    public void setNewCommitterName(String newCommitterName) {
        this.newCommitterName = newCommitterName;
    }

    public String getDisplayName() {
        return this.getUserManager().getUser(this.oldUserName).getDisplayName();
    }

    public String getNewUserName() {
        return this.newUserName;
    }

    public void setNewUserName(String newUserName) {
        this.newUserName = newUserName;
    }

    public String getOldUserName() {
        return this.oldUserName;
    }

    public void setOldUserName(String oldUserName) {
        this.oldUserName = oldUserName;
    }

    public String getOldCommitterName() {
        return this.oldCommitterName;
    }

    public void setOldCommitterName(String oldCommitterName) {
        this.oldCommitterName = oldCommitterName;
    }

    public List<String> getPossibleUserNames() {
        return ImmutableList.copyOf(this.getUserManager().getAllLicensedUsernames());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getPossibleCommitterNames(String rep) {
        List<String> results = new ArrayList<String>();
        RepositoryHandle handle = this.repositoryManager.getRepository(rep);
        if (handle != null) {
            Disposer.pushThreadInstance();
            try {
                results = handle.acquireEngine().getRevisionCache().findAuthors(Path.ROOT);
            }
            catch (DbException dbException) {
            }
            catch (RepositoryHandle.StateException stateException) {
            }
            finally {
                Disposer.popThreadInstance();
            }
        }
        return results;
    }

    public List<RepositoryHandle> getPossibleRepositoryNames() {
        return RepositoryUtil.repositories(this.request);
    }

    @RequireSecurityToken(value=false)
    public String doDefault() throws Exception {
        return super.doDefault();
    }

    @Override
    public String execute() {
        CommitterUserMapping oldMapping = new CommitterUserMapping(this.oldUserName, this.oldRepositoryName, this.oldCommitterName);
        CommitterUserMapping newMapping = new CommitterUserMapping(this.newUserName, this.newRepositoryName, this.newCommitterName);
        this.getUserMappingManager().updateMapping(oldMapping, newMapping);
        return "success";
    }

    @Override
    public void setServletRequest(HttpServletRequest request) {
        this.request = request;
    }
}

