/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions.user;

import com.atlassian.crucible.spi.services.NotPermittedException;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.fisheye.web.admin.actions.user.BaseUserAdminAction;
import com.google.common.base.Strings;
import java.util.LinkedList;
import java.util.List;

public class EditUserGroupsAdminAction
extends BaseUserAdminAction {
    private String uname;
    private List<String> availableGroups;
    private String[] addGroups = new String[0];
    private String[] deleteGroups = new String[0];
    private String join;
    private String leave;

    public void setJoin(String join) {
        this.join = join;
    }

    public void setLeave(String leave) {
        this.leave = leave;
    }

    public String getUname() {
        return this.uname;
    }

    public void setUname(String uname) {
        this.uname = uname;
    }

    public void setAddGroups(String[] addGroups) {
        this.addGroups = addGroups;
    }

    public void setDeleteGroups(String[] deleteGroups) {
        this.deleteGroups = deleteGroups;
    }

    public List<String> getAvailableGroups() {
        if (this.availableGroups == null) {
            this.availableGroups = new LinkedList<String>(this.getGroupNames());
            this.availableGroups.removeAll(this.getUserGroups());
        }
        return this.availableGroups;
    }

    public List<String> getUserGroups() {
        return this.getUserGroups(this.uname);
    }

    @RequireSecurityToken(value=false)
    public String doDefault() throws Exception {
        this.assertUserName(this.uname);
        return "success";
    }

    @Override
    public String execute() throws Exception {
        this.assertUserName(this.uname);
        try {
            if (!Strings.isNullOrEmpty((String)this.join)) {
                for (String group : this.addGroups) {
                    this.groupMembershipManager.addUserToGroup(group, this.uname);
                }
            }
            if (!Strings.isNullOrEmpty((String)this.leave)) {
                for (String group : this.deleteGroups) {
                    this.groupMembershipManager.removeUserFromGroup(group, this.uname);
                }
            }
        }
        catch (NotPermittedException e2) {
            this.addActionErrorAndLogWarning(e2.getMessage(), e2);
        }
        return "success";
    }
}

