/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions.user;

import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.web.admin.actions.BaseAdminAction;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class EditSysAdminsAction
extends BaseAdminAction {
    private List<String> addGroups = Collections.emptyList();
    private List<String> removeGroups = Collections.emptyList();
    private List<String> addUsers = Collections.emptyList();
    private List<String> removeUsers = Collections.emptyList();
    private String addUser;
    private String removeUser;
    private String addGroup;
    private String removeGroup;
    private Set<String> adminGroups;
    private Set<String> adminUsers;
    private List<String> nonAdminGroups;
    private Set<String> nonAdminUsers;

    public void setAddGroups(String[] addGroups) {
        this.addGroups = Arrays.asList(addGroups);
        this.addGroups.removeAll(this.adminGroups);
    }

    public void setRemoveGroups(String[] removeGroups) {
        this.removeGroups = Arrays.asList(removeGroups);
        this.removeGroups.removeAll(this.nonAdminGroups);
    }

    public void setAddUsers(String[] addUsers) {
        this.addUsers = Arrays.asList(addUsers);
        this.addUsers.removeAll(this.adminUsers);
    }

    public void setRemoveUsers(String[] removeUsers) {
        this.removeUsers = Arrays.asList(removeUsers);
        this.removeUsers.removeAll(this.nonAdminUsers);
    }

    @RequireSecurityToken(value=false)
    public String doDefault() throws Exception {
        return "success";
    }

    @Override
    public String execute() throws Exception {
        if (!Strings.isNullOrEmpty((String)this.addUser)) {
            for (String user : this.addUsers) {
                this.adminUserConfig.addUser(user);
            }
        }
        if (!Strings.isNullOrEmpty((String)this.removeUser)) {
            for (String user : this.removeUsers) {
                this.adminUserConfig.removeUser(user);
            }
        }
        if (!Strings.isNullOrEmpty((String)this.addGroup)) {
            for (String group : this.addGroups) {
                this.adminUserConfig.addGroup(group);
            }
        }
        if (!Strings.isNullOrEmpty((String)this.removeGroup)) {
            for (String group : this.removeGroups) {
                this.adminUserConfig.removeGroup(group);
            }
        }
        AppConfig.getsConfig().saveConfig();
        return "success";
    }

    public Set<String> getAdminGroups() {
        if (this.adminGroups == null) {
            this.adminGroups = this.adminUserConfig.getGroupSet();
        }
        return this.adminGroups;
    }

    public Set<String> getAdminUsers() {
        if (this.adminUsers == null) {
            this.adminUsers = this.adminUserConfig.getUserSet();
        }
        return this.adminUsers;
    }

    public List<String> getNonAdminGroups() {
        if (this.nonAdminGroups == null) {
            this.nonAdminGroups = new LinkedList<String>(this.getGroupNames());
            this.nonAdminGroups.removeAll(this.getAdminGroups());
            Collections.sort(this.nonAdminGroups, String.CASE_INSENSITIVE_ORDER);
        }
        return this.nonAdminGroups;
    }

    public Set<String> getNonAdminUsers() {
        if (this.nonAdminUsers == null) {
            this.nonAdminUsers = Sets.newTreeSet((Comparator)String.CASE_INSENSITIVE_ORDER);
            Iterables.addAll(this.nonAdminUsers, this.getUserManager().getAllLicensedUsernames());
            this.nonAdminUsers.removeAll(this.getAdminUsers());
        }
        return this.nonAdminUsers;
    }

    public String getRemoveGroup() {
        return this.removeGroup;
    }

    public void setRemoveGroup(String removeGroup) {
        this.removeGroup = removeGroup;
    }

    public String getAddGroup() {
        return this.addGroup;
    }

    public void setAddGroup(String addGroup) {
        this.addGroup = addGroup;
    }

    public String getRemoveUser() {
        return this.removeUser;
    }

    public void setRemoveUser(String removeUser) {
        this.removeUser = removeUser;
    }

    public String getAddUser() {
        return this.addUser;
    }

    public void setAddUser(String addUser) {
        this.addUser = addUser;
    }
}

