/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions.user;

import com.atlassian.crucible.spi.services.UserService;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.view.reviewfilters.ReviewFilters;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.web.admin.actions.user.BulkEditType;
import com.cenqua.fisheye.web.admin.actions.user.UserAdminAction;
import com.cenqua.fisheye.web.tags.ExpressionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class BulkUserEditAction
extends UserAdminAction {
    private List<String> selectedUsers;
    private BulkEditType editType;
    private final List<String> warnings = new ArrayList<String>();
    private final String UNKNOWN_BULK_EDIT_TYPE_ERROR = "The type of bulk action that was requested is not known.";
    private final String NO_USERS_SELECTED_ERROR = "No users were selected for the bulk action to occur on.";
    private final String DB_ERROR = "There was an error in the database, please inform an administrator to review the logs for further information.";
    @Autowired
    private UserManager userManager;
    @Autowired
    private UserService userService;
    @Autowired
    private ReviewManager reviewManager;

    public BulkEditType getEditType() {
        return this.editType;
    }

    public List<String> getSelectedUsers() {
        return this.selectedUsers;
    }

    public int getSelectedUsersCount() {
        return this.selectedUsers.size();
    }

    public void setEditType(String editType) {
        try {
            this.editType = BulkEditType.valueOf(editType);
        }
        catch (IllegalArgumentException e2) {
            this.editType = null;
        }
    }

    public void setSelectedUsers(String[] selectedUsers) {
        this.selectedUsers = Arrays.asList(selectedUsers);
    }

    public String getSuccessMessage() {
        if (this.selectedUsers != null) {
            int numUsers = this.selectedUsers.size();
            return this.editType.getPastTenseActionNameWithJoiningWord() + " " + numUsers + " user" + ExpressionUtil.pluralise("", "s", numUsers);
        }
        return null;
    }

    private String deleteUsers() {
        String result;
        try {
            if (this.userManager.deleteMultipleUsersAndRemoveCommitterMappings(this.selectedUsers)) {
                result = "success";
                this.addActionMessage(this.getSuccessMessage());
            } else {
                result = "error";
                this.addActionError("Error occurred whilst deleting users.");
            }
        }
        catch (Exception e2) {
            Logs.APP_LOG.warn((Object)("Error deleting user" + ExpressionUtil.pluralise("", "s", this.selectedUsers.size())), (Throwable)e2);
            this.addActionError("There was an error in the database, please inform an administrator to review the logs for further information.");
            result = "error";
        }
        return result;
    }

    private String checkFormConstraints() {
        if (this.selectedUsers == null || this.selectedUsers.isEmpty()) {
            this.addActionError("No users were selected for the bulk action to occur on.");
            return "error";
        }
        if (this.editType == null) {
            this.addActionError("The type of bulk action that was requested is not known.");
            return "error";
        }
        return "success";
    }

    @Override
    public String execute() throws Exception {
        String result = this.checkFormConstraints();
        if ("success".equalsIgnoreCase(result)) {
            switch (this.editType) {
                case DELETE: {
                    result = this.deleteUsers();
                    break;
                }
                default: {
                    result = "error";
                }
            }
        }
        super.execute();
        return result;
    }

    @RequireSecurityToken(value=false)
    public String doDefault() throws Exception {
        String result = this.checkFormConstraints();
        if (!"success".equalsIgnoreCase(result)) {
            super.execute();
            return result;
        }
        return super.doDefault();
    }

    public List<String> getSelectedUsersWarnings() {
        if (this.editType.getIsDisruptive()) {
            for (String s2 : this.selectedUsers) {
                int numActiveReviews = this.getNumActiveReviews(s2);
                if (numActiveReviews <= 0) continue;
                this.warnings.add(s2 + " has " + numActiveReviews + " active review" + ExpressionUtil.pluralise("", "s", numActiveReviews));
            }
        }
        return this.warnings;
    }

    private int getNumActiveReviews(String uname) {
        FecruUser user = this.userManager.getUser(uname);
        ReviewFilters f2 = new ReviewFilters(user);
        return this.reviewManager.getMatchingReviewIds(f2.getFilterDefByKey(ReviewFilters.FilterKey.ACTIVE_PARTICIPANT), null).size();
    }
}

