/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions.user;

import com.atlassian.fecru.web.exception.Http404Exception;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.web.admin.actions.BaseAdminAction;
import com.google.common.base.Strings;
import java.util.Collections;
import java.util.List;

public class BaseUserAdminAction
extends BaseAdminAction {
    protected static final String USERNAME_FIELD = "username";
    protected static final String USER_EMAIL_FIELD = "userEmail";
    protected static final String USER_DISPLAY_NAME_FIELD = "userDisplayName";
    private List<String> userGroups;

    public List<String> getUserGroups(String username) {
        if (this.userGroups == null) {
            if (!Strings.isNullOrEmpty((String)username) && this.userManager.getUser(username) != null) {
                try {
                    this.userGroups = this.groupMembershipManager.getGroupsForUser(username);
                }
                catch (Exception e2) {
                    Logs.APP_LOG.warn((Object)"Problem getting group list", (Throwable)e2);
                    this.userGroups = Collections.emptyList();
                }
            } else {
                this.userGroups = Collections.emptyList();
            }
        }
        return this.userGroups;
    }

    protected void assertUserName(String uname) throws Http404Exception {
        if (Strings.isNullOrEmpty((String)uname) && this.userManager.getUser(uname) != null) {
            throw new Http404Exception("No user specified");
        }
    }
}

