/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions.user;

import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.util.Disposer;
import com.cenqua.fisheye.web.admin.actions.BaseAdminAction;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;

public class AddUserMappingAction
extends BaseAdminAction {
    private String userName;
    private String committerName;
    private String repositoryName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getCommitters(String rep) {
        List<String> results = new ArrayList<String>();
        RepositoryHandle handle = this.repositoryManager.getRepository(rep);
        if (handle != null) {
            Disposer.pushThreadInstance();
            try {
                results = handle.acquireEngine().getRevisionCache().findAuthors(Path.ROOT);
            }
            catch (DbException dbException) {
            }
            catch (RepositoryHandle.StateException stateException) {
            }
            finally {
                Disposer.popThreadInstance();
            }
        }
        return results;
    }

    public List<String> getUserNames() {
        return ImmutableList.copyOf(this.getUserManager().getAllLicensedUsernames());
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getCommitterName() {
        return this.committerName;
    }

    public void setCommitterName(String committerName) {
        this.committerName = committerName;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    @RequireSecurityToken(value=false)
    public String doDefault() throws Exception {
        return super.doDefault();
    }

    @Override
    public String execute() {
        this.getUserMappingManager().addMapping(this.userName, this.repositoryName, this.committerName);
        return "success";
    }
}

