/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions.setup;

import com.atlassian.applinks.api.ApplicationLinkService;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config1.LicenseType;
import com.cenqua.fisheye.license.LicenseHolder;
import com.cenqua.fisheye.web.admin.actions.setup.SetupModel;
import com.cenqua.fisheye.web.filters.GlobalJspContext;
import com.cenqua.fisheye.web.filters.GlobalJspContextFactory;
import com.google.common.collect.Iterables;
import com.opensymphony.webwork.interceptor.ServletRequestAware;
import com.opensymphony.xwork.ActionSupport;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class SetupAction
extends ActionSupport
implements ServletRequestAware {
    protected HttpServletRequest request;
    protected GlobalJspContext context;
    protected GlobalJspContextFactory globalJspContextFactory;
    protected ApplicationLinkService applicationLinkService;
    protected RootConfig config;
    private final Product downloadedProduct;
    private final int pageOrder;
    private SetupModel model;
    private String viewName;

    public SetupAction(int pageOrder) {
        this.pageOrder = pageOrder;
        this.downloadedProduct = AppConfig.isFisheyeDownload() && !AppConfig.isCrucibleDownload() ? Product.FISHEYE : Product.CRUCIBLE;
    }

    @Autowired
    public void setJspContextFactory(GlobalJspContextFactory globalJspContextFactory) {
        this.globalJspContextFactory = globalJspContextFactory;
    }

    @Autowired
    public void setApplicationLinkService(ApplicationLinkService applicationLinkService) {
        this.applicationLinkService = applicationLinkService;
    }

    @Autowired
    public void setRootConfig(RootConfig config) {
        boolean inclusionSet;
        String feLic;
        String cruLic;
        this.config = config;
        boolean isSetLicense = config.getConfig().isSetLicense();
        boolean jiraConnectDone = this.wasJiraSetupPerformed();
        if (isSetLicense) {
            LicenseType license = config.getConfig().getLicense();
            cruLic = license.isSetCrucible() ? license.getCrucible() : null;
            feLic = license.isSetFisheye() ? license.getFisheye() : null;
            inclusionSet = AppConfig.isCrucibleDownload() ? license.isSetFisheye() : license.isSetCrucible();
        } else {
            cruLic = null;
            feLic = null;
            inclusionSet = false;
        }
        this.model = new SetupModel(cruLic, feLic, config.getAdminConfig().haveDoneInitialSetup(), AppConfig.isCrucibleDownload(), inclusionSet, jiraConnectDone, this.pageOrder);
    }

    public void setServletRequest(HttpServletRequest request) {
        this.request = request;
        this.context = this.globalJspContextFactory.make(request);
    }

    protected boolean saveConfig() {
        try {
            this.config.saveConfig();
        }
        catch (IOException e2) {
            this.handleSaveConfigException(e2);
            return false;
        }
        return true;
    }

    protected void handleSaveConfigException(IOException e2) {
        this.addActionError("Error saving config. Please ensure the config.xml is writeable: " + e2.getMessage());
        LOG.error((Object)e2.getMessage(), (Throwable)e2);
    }

    public int getPageOrder() {
        return this.pageOrder;
    }

    public String getViewName() {
        return this.viewName;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    public SetupModel getModel() {
        return this.model;
    }

    public String getDownloadedProductName() {
        return this.downloadedProduct.name;
    }

    public String getDownloadedProductHelpPathPrefix() {
        return this.downloadedProduct.helpPathPrefix;
    }

    public boolean isDownloadedCrucible() {
        return this.downloadedProduct == Product.CRUCIBLE;
    }

    public boolean isCrucibleOnly() {
        return this.getLicenseHolder().isCrucibleOnly();
    }

    public boolean isFishEyeOnly() {
        return this.getLicenseHolder().hasFishEye() && !this.getLicenseHolder().hasCrucible();
    }

    public String getIncludedProductName() {
        return this.downloadedProduct == Product.FISHEYE ? Product.CRUCIBLE.name : Product.FISHEYE.name;
    }

    public String getBuildDate() {
        return this.context.getFisheyeVersionInfo().getBuildDate();
    }

    public boolean isCrucibleEval() {
        LicenseHolder licenseHolder = this.getLicenseHolder();
        return licenseHolder.getCrucibleLicense() != null && licenseHolder.getCrucibleLicense().isEvaluation() && !licenseHolder.isSyntheticCrucibleEval();
    }

    public boolean isFishEyeEval() {
        LicenseHolder licenseHolder = this.getLicenseHolder();
        return licenseHolder.getFishEyeLicense() != null && licenseHolder.getFishEyeLicense().isEvaluation() && !licenseHolder.isSyntheticFishEyeEval();
    }

    protected boolean wasJiraSetupPerformed() {
        Iterable links = this.applicationLinkService.getApplicationLinks();
        return !Iterables.isEmpty((Iterable)links);
    }

    public SetupAction getThis() {
        return this;
    }

    private LicenseHolder getLicenseHolder() {
        return LicenseHolder.makeFishEyeCrucibleLicense(this.getModel().getFeLicense(), this.getModel().getCruLicense());
    }

    public static String stateFor(SetupAction action, int page, boolean pageComplete) {
        if (page == action.getPageOrder()) {
            return "current";
        }
        return pageComplete ? "complete" : "incomplete";
    }

    public String getTroubleShootingPageKey() {
        return null;
    }

    private static enum Product {
        FISHEYE("FishEye", "fisheye"),
        CRUCIBLE("Crucible", "crucible");

        final String name;
        final String helpPathPrefix;

        private Product(String name, String helpPathPrefix) {
            this.name = name;
            this.helpPathPrefix = helpPathPrefix;
        }
    }
}

