/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions.setup;

import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.web.admin.actions.setup.SetupAction;
import org.apache.commons.lang.StringUtils;

public class PasswordAction
extends SetupAction {
    private String password1;
    private String password2;
    private boolean allowedToGoBack = false;
    public static final String ERR_MISSING = "Password is missing";
    public static final String ERR_TOO_SHORT = "Your admin password must be at least 6 characters, and preferably a mixture of numbers and letters";
    public static final String ERR_DONT_MATCH = "Passwords don't match";

    public PasswordAction() {
        super(3);
    }

    public void setPassword1(String password) {
        this.password1 = password;
    }

    public void setPassword2(String password) {
        this.password2 = password;
    }

    public String getPassword1() {
        return this.password1;
    }

    public String getPassword2() {
        return this.password2;
    }

    public boolean isAllowedToGoBack() {
        return this.allowedToGoBack;
    }

    public void validate() {
        this.validatePassword();
        if (this.hasFieldErrors()) {
            this.allowedToGoBack = !this.wasJiraSetupPerformed();
        }
    }

    private void validatePassword() {
        if (StringUtils.isBlank((String)this.password1)) {
            this.addFieldError("password1", ERR_MISSING);
            return;
        }
        if (this.password1.length() < 6) {
            this.addFieldError("password1", ERR_TOO_SHORT);
            return;
        }
        if (!this.password1.equals(this.password2)) {
            this.addFieldError("password1", ERR_DONT_MATCH);
        }
    }

    public String execute() {
        if (this.config.getAdminConfig().haveDoneInitialSetup()) {
            return "forbidden";
        }
        try {
            this.config.getAdminConfig().setAdminPassword(this.password1);
            return "success";
        }
        catch (Exception e2) {
            this.addActionError(e2.getMessage());
            Logs.APP_LOG.error((Object)"Error while updating the configuration", (Throwable)e2);
            return "error";
        }
    }

    public String doView() {
        if (!this.getModel().isLicenseSet()) {
            return "license";
        }
        if (this.getModel().isAdminPasswordSet()) {
            return "done";
        }
        this.allowedToGoBack = !this.wasJiraSetupPerformed();
        return "input";
    }
}

