/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions.setup;

import com.atlassian.fecru.license.LicenseManager;
import com.cenqua.fisheye.FisheyeVersionInfo;
import com.cenqua.fisheye.license.LicenseHolder;
import com.cenqua.fisheye.license.LicenseUtils;
import com.cenqua.fisheye.web.ServletUtils;
import com.cenqua.fisheye.web.admin.actions.setup.SetupAction;
import com.cenqua.fisheye.web.util.FishEyeURLEncoder;
import java.io.IOException;
import java.util.Date;
import javax.annotation.Resource;

public class LicenseAction
extends SetupAction {
    public static final String ERR_LIC_NOT_SET = "License is not set.";
    public static final String ERR_DECODER = "This license can not be decoded.";
    public static final String ERR_LIC_INVALID = "Upgrades for your license ended %1$tY-%1$tm-%1$td and this version was built %2$s";
    public static final String ERR_LIC_EXPIRED = "This license has expired.";
    @Resource
    private LicenseManager licenseManager;

    public LicenseAction() {
        super(0);
    }

    protected LicenseAction(int order) {
        super(order);
    }

    public void setCrucibleLicense(String license) {
        this.getModel().setCruLicense(license);
    }

    public String getFishEyeLicense() {
        return this.getModel().getFeLicense();
    }

    public String getCrucibleLicense() {
        return this.getModel().getCruLicense();
    }

    public void setFishEyeLicense(String license) {
        this.getModel().setFeLicense(license);
    }

    public String getGenerateLicenseUrl() {
        String callback = ServletUtils.getBaseUrl(this.request) + "/setup/save" + this.getDownloadedProductName() + "License.do";
        return this.makeLicenseUrl(this.getDownloadedProductName(), new FisheyeVersionInfo(), callback);
    }

    public String getSid() {
        return new FisheyeVersionInfo().getSid();
    }

    protected LicenseManager getLicenseManager() {
        return this.licenseManager;
    }

    private String saveLicense(String license, LicenseDelegate delegate) {
        if (license == null || license.trim().length() == 0) {
            this.addFieldError(delegate.getFieldName(), ERR_LIC_NOT_SET);
            return "error";
        }
        String enteredOtherLicenseMsg = delegate.checkForOtherLicense();
        if (enteredOtherLicenseMsg != null) {
            this.addFieldError(delegate.getFieldName(), enteredOtherLicenseMsg);
            return "error";
        }
        if (!delegate.canDecode()) {
            this.addFieldError(delegate.getFieldName(), ERR_DECODER);
            return "error";
        }
        if (!delegate.isValidForCurrentBuild()) {
            this.addFieldError(delegate.getFieldName(), String.format(ERR_LIC_INVALID, delegate.getLatestBuildAllowed(), this.getBuildDate()));
            return "error";
        }
        if (delegate.isGracePeriodExpired()) {
            this.addFieldError(delegate.getFieldName(), ERR_LIC_EXPIRED);
            return "error";
        }
        return this.persistLicenseToConfig();
    }

    protected String persistLicenseToConfig() {
        String outcome = "success";
        try {
            this.getLicenseManager().updateLicenses(this.getFishEyeLicense(), this.getCrucibleLicense());
        }
        catch (IOException e2) {
            this.handleSaveConfigException(e2);
            outcome = "error";
        }
        return outcome;
    }

    public String doSaveCrucible() {
        CruLicenseDelegate delegate = new CruLicenseDelegate(LicenseHolder.makeFishEyeCrucibleLicense(null, this.getCrucibleLicense()));
        return this.saveLicense(this.getCrucibleLicense(), delegate);
    }

    public String doSaveFishEye() {
        FeLicenseDelegate delegate = new FeLicenseDelegate(LicenseHolder.makeFishEyeCrucibleLicense(this.getFishEyeLicense(), null));
        return this.saveLicense(this.getFishEyeLicense(), delegate);
    }

    public boolean isDisplayLicenseForm() {
        return this.hasFieldErrors() && (this.getCrucibleLicense() != null || this.getFishEyeLicense() != null);
    }

    public String doView() {
        this.setViewName(this.getModel().isCrucibleDownload() ? "cruLicense.jsp" : "feLicense.jsp");
        return "input";
    }

    protected String makeLicenseUrl(String productName, FisheyeVersionInfo versionInfo, String callback) {
        StringBuilder base = new StringBuilder("http://www.atlassian.com/ex/GenerateLicense.jspa");
        base.append("?utm_nooverride=1").append("&ref=prod").append("&product=").append(FishEyeURLEncoder.uriEncode(productName)).append("&version=").append(FishEyeURLEncoder.uriEncode(versionInfo.getReleaseNum())).append("&build=").append(FishEyeURLEncoder.uriEncode(versionInfo.getBuildNumber())).append("&sid=").append(FishEyeURLEncoder.uriEncode(versionInfo.getSid())).append("&licensefieldname=").append(FishEyeURLEncoder.uriEncode(productName + "License")).append("&callback=").append(FishEyeURLEncoder.pathEncode(callback));
        return base.toString();
    }

    class FeLicenseDelegate
    implements LicenseDelegate {
        final LicenseHolder holder;

        private FeLicenseDelegate(LicenseHolder holder) {
            this.holder = holder;
        }

        @Override
        public boolean canDecode() {
            return this.holder.canDecodeFishEye();
        }

        @Override
        public boolean isValidForCurrentBuild() {
            return this.holder.isFishEyeValidForCurrentBuild();
        }

        @Override
        public boolean isGracePeriodExpired() {
            return this.holder.isFishEyeGracePeriodExpired();
        }

        @Override
        public Date getLatestBuildAllowed() {
            return new Date(LicenseUtils.getLatestBuildAllowed(this.holder.getFishEyeLicense()));
        }

        @Override
        public String getFieldName() {
            return "FishEyeLicense";
        }

        @Override
        public String checkForOtherLicense() {
            LicenseHolder invertedHolder = LicenseHolder.makeCrucibleOnlyLicense(this.holder.getFishEyeLicenseString());
            return invertedHolder.hasCrucible() ? "You've entered a Crucible license. Please enter a FishEye license instead." : null;
        }
    }

    class CruLicenseDelegate
    implements LicenseDelegate {
        final LicenseHolder holder;

        private CruLicenseDelegate(LicenseHolder holder) {
            this.holder = holder;
        }

        @Override
        public boolean canDecode() {
            return this.holder.canDecodeCrucible();
        }

        @Override
        public boolean isValidForCurrentBuild() {
            return this.holder.isCrucibleValidForCurrentBuild();
        }

        @Override
        public boolean isGracePeriodExpired() {
            return this.holder.isCrucibleGracePeriodExpired();
        }

        @Override
        public Date getLatestBuildAllowed() {
            return new Date(LicenseUtils.getLatestBuildAllowed(this.holder.getCrucibleLicense()));
        }

        @Override
        public String getFieldName() {
            return "CrucibleLicense";
        }

        @Override
        public String checkForOtherLicense() {
            LicenseHolder invertedHolder = LicenseHolder.makeFishEyeOnlyLicense(this.holder.getCrucibleLicenseString());
            return invertedHolder.hasFishEye() ? "You've entered a FishEye license. Please enter a Crucible license instead." : null;
        }
    }

    static interface LicenseDelegate {
        public boolean canDecode();

        public boolean isValidForCurrentBuild();

        public boolean isGracePeriodExpired();

        public String getFieldName();

        public String checkForOtherLicense();

        public Date getLatestBuildAllowed();
    }
}

