/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions.setup;

import com.atlassian.fecru.applinks.FeCruHostApplication;
import com.atlassian.fisheye.jira.setup.JiraSetupException;
import com.atlassian.fisheye.jira.setup.JiraSetupService;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.web.admin.actions.setup.SetupAction;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashSet;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;

public class JiraConnectAction
extends SetupAction {
    private static final String DONE = "done";
    private static final String DEFAULT_GROUPS = "jira-users";
    private static final String DEFAULT_ADMIN_GROUPS = "jira-administrators";
    @Resource
    private JiraSetupService jiraSetupService;
    @Resource
    private FeCruHostApplication hostApplication;
    private String next;
    private String jiraUrl;
    private String jiraAdminUser;
    private String jiraAdminPassword;
    private String fishEyeUrl;
    private String groups;
    private String adminGroups;

    public JiraConnectAction() {
        super(2);
    }

    public String doView() {
        if (this.config.getAdminConfig().haveDoneInitialSetup()) {
            return "forbidden";
        }
        if (StringUtils.isEmpty((String)this.next)) {
            return this.wasJiraSetupPerformed() ? DONE : "input";
        }
        if ("skip".equals(this.next)) {
            return DONE;
        }
        if ("connect".equals(this.next)) {
            return this.tryConnectToJIRA() ? DONE : "error";
        }
        return "error";
    }

    private boolean tryConnectToJIRA() {
        if (!this.validateFields()) {
            return false;
        }
        URI jiraUri = this.toURI(this.jiraUrl);
        URI fisheyeUri = this.toURI(this.getFishEyeUrl());
        Collection<String> groupsWithFecruAccess = this.csvToIterable(this.groups);
        Collection<String> adminGroupsToSync = this.csvToIterable(this.adminGroups);
        if (jiraUri != null && fisheyeUri != null) {
            try {
                this.jiraSetupService.linkFishEyeToJIRA(jiraUri, fisheyeUri, this.jiraAdminUser, this.jiraAdminPassword, groupsWithFecruAccess, adminGroupsToSync);
                return true;
            }
            catch (JiraSetupException e2) {
                Logs.APP_LOG.error((Object)e2.getMessage(), (Throwable)e2);
                this.addActionError(e2.getMessage());
            }
            catch (Exception e3) {
                Logs.APP_LOG.error((Object)e3.toString(), (Throwable)e3);
                this.addActionError("An error occurred: " + e3.toString() + ". Please refer to the logs for details.");
            }
        }
        return false;
    }

    private boolean validateFields() {
        if (this.jiraUrl == null || this.jiraUrl.isEmpty()) {
            this.addActionError("You must specify a JIRA base URL to connect to.");
        }
        if (this.jiraAdminUser == null || this.jiraAdminUser.isEmpty() || this.jiraAdminPassword == null || this.jiraAdminPassword.isEmpty()) {
            this.addActionError("You must specify JIRA system administrator credentials to create the connection.");
        }
        return !this.hasActionErrors();
    }

    private URI toURI(String url) {
        String lcUrl = url.toLowerCase();
        if (!lcUrl.startsWith("http://") && !lcUrl.startsWith("https://")) {
            this.addActionError("The URL " + url + " must start with http:// or https://");
            return null;
        }
        try {
            return new URI(url);
        }
        catch (URISyntaxException e2) {
            this.addActionError(url + " is not a valid URL");
            return null;
        }
    }

    private Collection<String> csvToIterable(String csv) {
        HashSet<String> groups = new HashSet<String>();
        if (csv != null) {
            for (String val : csv.split(",")) {
                if ((val = val.trim()).isEmpty()) continue;
                groups.add(val);
            }
        }
        return groups;
    }

    private String cleanUrl(String url) {
        if (url != null && url.length() > 0 && url.charAt(url.length() - 1) == '/') {
            return url.substring(0, url.length() - 1);
        }
        return url != null ? url.trim() : url;
    }

    public void setNext(String next) {
        this.next = next;
    }

    public void setJiraUrl(String jiraUrl) {
        this.jiraUrl = this.cleanUrl(jiraUrl);
    }

    public void setJiraAdminUser(String jiraAdminUser) {
        this.jiraAdminUser = jiraAdminUser;
    }

    public void setJiraAdminPassword(String jiraAdminPassword) {
        this.jiraAdminPassword = jiraAdminPassword;
    }

    public void setFishEyeUrl(String fishEyeUrl) {
        this.fishEyeUrl = this.cleanUrl(fishEyeUrl);
    }

    public void setGroups(String groups) {
        this.groups = groups;
    }

    public void setAdminGroups(String adminGroups) {
        this.adminGroups = adminGroups;
    }

    public String getJiraUrl() {
        return this.jiraUrl;
    }

    public String getJiraAdminUser() {
        return this.jiraAdminUser;
    }

    public String getJiraAdminPassword() {
        return this.jiraAdminPassword;
    }

    public String getFishEyeUrl() {
        if (this.fishEyeUrl == null || this.fishEyeUrl.trim().isEmpty()) {
            this.fishEyeUrl = this.hostApplication.getBaseUrl().toString();
        }
        return this.fishEyeUrl;
    }

    public String getGroups() {
        if (this.groups == null) {
            this.groups = DEFAULT_GROUPS;
        }
        return this.groups;
    }

    public String getAdminGroups() {
        if (this.adminGroups == null) {
            this.adminGroups = DEFAULT_ADMIN_GROUPS;
        }
        return this.adminGroups;
    }

    @Override
    public String getTroubleShootingPageKey() {
        return this.getDownloadedProductHelpPathPrefix() + ".jaacs.setup.troubleshooting";
    }
}

