/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions.sec;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config1.SecurityType;
import com.cenqua.fisheye.logging.Logs;
import com.opensymphony.xwork.ActionSupport;
import java.io.IOException;
import java.math.BigInteger;

public class EditLoginCaptchaAction
extends ActionSupport {
    private boolean captchaEnabled;
    private Long maxLogins;

    public EditLoginCaptchaAction() {
        SecurityType sec = this.getSecurityConfig();
        this.captchaEnabled = sec.getEnableLoginCaptcha();
        this.maxLogins = sec.getMaxLoginFailures().longValue();
    }

    private SecurityType getSecurityConfig() {
        return AppConfig.getsConfig().getConfig().getSecurity();
    }

    public String execute() {
        SecurityType sec = this.getSecurityConfig();
        sec.setEnableLoginCaptcha(this.captchaEnabled);
        sec.setMaxLoginFailures(BigInteger.valueOf(this.maxLogins));
        try {
            AppConfig.getsConfig().saveConfig();
        }
        catch (IOException e2) {
            Logs.APP_LOG.error((Object)("Unable to save config file: " + e2.getMessage()));
        }
        return "success";
    }

    public void setCaptchaEnabled(String captchaEnabled) {
        this.captchaEnabled = Boolean.parseBoolean(captchaEnabled);
    }

    public void setMaxLogins(String maxLogins) {
        try {
            this.maxLogins = Math.max(0L, Long.parseLong(maxLogins));
        }
        catch (NumberFormatException nfe) {
            Logs.APP_LOG.error((Object)("Invalid value specified for max-login-failures: " + maxLogins), (Throwable)nfe);
        }
    }
}

