/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions.sec;

import com.atlassian.fecru.user.EffectiveUserProvider;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.EmailVisibilityType;
import com.cenqua.fisheye.config1.SecurityType;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.web.admin.util.AdminActionUtils;
import com.opensymphony.xwork.ActionSupport;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;

public class EditEmailVisibilityAction
extends ActionSupport {
    @Resource
    protected RootConfig rootConfig;
    @Resource
    private EffectiveUserProvider effectiveUserProvider;
    private static Map<Integer, String> emailVisibilityOptions = new HashMap<Integer, String>();
    private EmailVisibilityType.Visibility.Enum emailVisibility;

    public final ConfigDocument.Config getCfg() {
        return AdminActionUtils.getCfg(this, this.effectiveUserProvider, this.rootConfig);
    }

    public static Map<Integer, String> getEmailVisibilityMap() {
        return emailVisibilityOptions;
    }

    public static Integer getEmailVisibility() {
        SecurityType securityType = AppConfig.getsConfig().getConfig().getSecurity();
        EmailVisibilityType vis = securityType.getEmailVisibility();
        if (vis == null || vis.getVisibility() == null) {
            if (vis == null) {
                vis = securityType.addNewEmailVisibility();
            }
            if (vis.getVisibility() == null) {
                vis.setVisibility(EmailVisibilityType.Visibility.PUBLIC);
            }
            try {
                AppConfig.getsConfig().saveConfig();
            }
            catch (IOException e2) {
                Logs.APP_LOG.error((Object)("Unable to save config file: " + e2.getMessage()));
            }
        }
        return vis.getVisibility().intValue();
    }

    public void setEmailVisibility(int emailVisibility) {
        this.emailVisibility = EmailVisibilityType.Visibility.Enum.forInt(emailVisibility);
    }

    public String execute() throws Exception {
        EmailVisibilityType vis;
        if (this.emailVisibility == null) {
            this.setEmailVisibility(1);
        }
        if ((vis = this.getCfg().getSecurity().getEmailVisibility()) == null) {
            vis = this.getCfg().getSecurity().addNewEmailVisibility();
        }
        vis.setVisibility(this.emailVisibility);
        AppConfig.getsConfig().saveConfig();
        return "success";
    }

    static {
        emailVisibilityOptions.put(1, "Public");
        emailVisibilityOptions.put(2, "Hidden");
        emailVisibilityOptions.put(3, "Visible to logged in users only");
    }
}

