/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions.sec;

import com.atlassian.fecru.user.EffectiveUserProvider;
import com.atlassian.xwork.ParameterSafe;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.CustomSecurityConfigType;
import com.cenqua.fisheye.config1.SecurityType;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.user.CustomAuth;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.web.admin.util.AdminActionUtils;
import com.opensymphony.xwork.ActionSupport;
import java.io.Writer;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.NDC;
import org.apache.log4j.PatternLayout;

public class CustomAuthEditAction
extends ActionSupport {
    @Resource
    protected RootConfig rootConfig;
    @Resource
    private EffectiveUserProvider effectiveUserProvider;
    @Resource
    protected UserManager userManager;
    private CustomSecurityConfigType customSec;

    @PostConstruct
    public void init() {
        SecurityType sec = this.getCfg().getSecurity();
        if (sec.isSetCustom()) {
            this.customSec = sec.getCustom();
        } else {
            this.customSec = CustomSecurityConfigType.Factory.newInstance();
            this.customSec.setAutoAdd(true);
            this.customSec.setPositiveCacheTtl("5 mins");
        }
    }

    @ParameterSafe
    public CustomSecurityConfigType getCustomAuth() {
        return this.customSec;
    }

    public final ConfigDocument.Config getCfg() {
        return AdminActionUtils.getCfg(this, this.effectiveUserProvider, this.rootConfig);
    }

    @RequireSecurityToken(value=false)
    public String doDefault() throws Exception {
        return "success";
    }

    public String execute() throws Exception {
        if (this.hasErrors()) {
            return "error";
        }
        this.getCfg().getSecurity().setCustom(this.customSec);
        AppConfig.getsConfig().saveConfig();
        this.userManager.reload(this.getCfg());
        return "success";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate() {
        if (this.hasErrors()) {
            return;
        }
        String ndc = "custom-auth-" + System.currentTimeMillis();
        Writer writer = new Writer(){

            @Override
            public void write(char[] chars, int i2, int i1) {
                CustomAuthEditAction.this.addActionError(new String(chars, i2, i1));
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() {
            }
        };
        Logger logger = Logs.makeAnonymousLogger();
        Appender appender = Logs.makeTestAppender(writer, ndc, null);
        appender.setLayout((Layout)new PatternLayout("%m%n"));
        logger.addAppender(appender);
        try {
            NDC.push((String)ndc);
            new CustomAuth(this.customSec, logger);
        }
        catch (Throwable e2) {
            logger.error((Object)("Could not instantiate Authenticator: " + this.customSec.getClassname()), e2);
        }
        finally {
            NDC.pop();
            logger.removeAppender(appender);
        }
    }
}

