/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions.sec;

import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.config1.SecurityType;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.user.Auth;
import com.cenqua.fisheye.user.AuthTok;
import com.cenqua.fisheye.user.AuthenticationException;
import com.cenqua.fisheye.user.CustomAuth;
import com.opensymphony.xwork.ActionSupport;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.Logger;
import org.apache.log4j.NDC;

public class AuthTestAction
extends ActionSupport {
    @Resource
    private RepositoryManager repositoryManager;
    private String username;
    private String password;
    private TestResults results;

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public TestResults getResults() {
        return this.results;
    }

    protected void addResult(String msg, boolean success) {
        this.results.results.add(new Result(msg, success));
    }

    protected void addResult(String msg) {
        this.results.results.add(new Result(msg, true));
    }

    public boolean getHasResults() {
        return this.results != null;
    }

    private void runAuthenticationChecks(Auth auth) throws AuthenticationException {
        AuthTok authTok = auth.authenticate(this.getUsername(), this.getPassword(), null, null);
        if (authTok == null) {
            this.addResult("username/password check failed", false);
            return;
        }
        this.addResult("username/password succeeded");
        this.addResult("user's display name is " + StringUtils.defaultIfEmpty((String)authTok.getDisplayName(), (String)"[empty] (check the 'Display name' attribute is correct in the Authentication configuration)"));
        this.addResult("user's email is " + StringUtils.defaultIfEmpty((String)authTok.getEmail(), (String)"[empty] (check the 'Email' attribute is correct in the Authentication configuration)"));
        this.addResult("Checking per-repository access");
        this.testRepositories(auth, authTok);
        this.addResult("Checking per-repository a second time (tests the permission cache)");
        this.testRepositories(auth, authTok);
    }

    private void testRepositories(final Auth auth, final AuthTok authTok) throws AuthenticationException {
        for (final RepositoryHandle rep : this.repositoryManager.getHandles()) {
            boolean access = authTok.hasPermissionToAccess(rep, new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return auth.hasPermissionToAccess(authTok, true, rep);
                }
            });
            this.addResult("- can " + this.getUsername() + " access the repository " + rep.getName() + "? " + (access ? "YES" : "NO"), access);
        }
    }

    @RequireSecurityToken(value=false)
    public String doDefault() throws Exception {
        return super.doDefault();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute() {
        this.results = new TestResults();
        Logger logger = Logs.makeAnonymousLogger();
        String ndc = "auth-test-" + System.currentTimeMillis();
        Appender appender = Logs.makeTestAppender(this.results.debug, ndc, new HashMap());
        try {
            logger.addAppender(appender);
            logger.debug((Object)"debug output follows");
            NDC.push((String)ndc);
            Auth auth = this.makeAuth(logger);
            if (auth != null) {
                this.runAuthenticationChecks(auth);
                auth.close();
            }
        }
        catch (AuthenticationException e2) {
            Throwable cause = e2.getCause() != null ? e2.getCause() : e2;
            Logs.APP_LOG.error((Object)"Error testing LDAP connection", (Throwable)e2);
            this.addResult("unexpected error: " + cause.getMessage(), false);
        }
        catch (Exception e3) {
            Logs.APP_LOG.error((Object)"Error testing LDAP connection", (Throwable)e3);
            this.addResult("unexpected error: " + e3.getMessage(), false);
        }
        finally {
            logger.removeAppender(appender);
            NDC.pop();
        }
        return "success";
    }

    protected Auth makeAuth(Logger logger) {
        SecurityType sec = AppConfig.getsConfig().getConfig().getSecurity();
        if (sec.isSetCustom()) {
            return new CustomAuth(sec.getCustom(), logger);
        }
        this.addResult("no specific authentication configured", false);
        return null;
    }

    public static class Result {
        final boolean success;
        final String message;

        public Result(String message, boolean success) {
            this.success = success;
            this.message = message;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public String getMessage() {
            return this.message;
        }
    }

    public static class TestResults {
        final StringWriter debug = new StringWriter();
        final List<Result> results = new LinkedList<Result>();

        public List<Result> getResults() {
            return this.results;
        }

        public String getDebug() {
            this.debug.flush();
            return this.debug.getBuffer().toString();
        }
    }
}

