/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions.sec;

import com.atlassian.fecru.user.EffectiveUserProvider;
import com.atlassian.xwork.ParameterSafe;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config1.AjpAuthConfigType;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.SecurityType;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.web.admin.util.AdminActionUtils;
import com.opensymphony.xwork.ActionSupport;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;

public class AjpAuthEditAction
extends ActionSupport {
    @Resource
    protected RootConfig rootConfig;
    @Resource
    private EffectiveUserProvider effectiveUserProvider;
    @Resource
    private UserManager userManager;
    private AjpAuthConfigType ajpAuth;

    @PostConstruct
    public void init() {
        SecurityType sec = this.getCfg().getSecurity();
        if (sec.isSetAjp()) {
            this.ajpAuth = sec.getAjp();
        } else {
            this.ajpAuth = AjpAuthConfigType.Factory.newInstance();
            this.ajpAuth.setAutoAdd(true);
            this.ajpAuth.setPositiveCacheTtl("5 mins");
        }
    }

    @ParameterSafe
    public AjpAuthConfigType getAjpAuth() {
        return this.ajpAuth;
    }

    public final ConfigDocument.Config getCfg() {
        return AdminActionUtils.getCfg(this, this.effectiveUserProvider, this.rootConfig);
    }

    @RequireSecurityToken(value=false)
    public String doDefault() throws Exception {
        return "success";
    }

    public String execute() throws Exception {
        this.getCfg().getSecurity().setAjp(this.ajpAuth);
        AppConfig.getsConfig().saveConfig();
        this.userManager.reload(this.getCfg());
        return "success";
    }

    public void validate() {
        if (this.hasErrors()) {
            return;
        }
    }
}

