/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions.plugins;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.descriptors.UnloadableModuleDescriptor;
import com.atlassian.plugin.descriptors.UnrecognisedModuleDescriptor;
import com.atlassian.plugin.impl.UnloadablePlugin;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="pluginDataFactory")
public class PluginDataFactory {
    private PluginAccessor pluginAccessor;
    public static final String PLUGIN = "plugin";
    public static final String MODULE = "module";
    public static final String ENABLE = "enable";
    public static final String DISABLE = "disable";

    @Autowired
    public PluginDataFactory(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    private static String getActionName(String state) {
        return state.equals("Enabled") ? "Disable" : (state.equals("Disabled") ? "Enable" : null);
    }

    private static String getActionParameters(String key, String type, String state) {
        String action;
        if (state.equals("Enabled")) {
            action = DISABLE;
        } else if (state.equals("Disabled")) {
            action = ENABLE;
        } else {
            return null;
        }
        return "key=" + key + "&type=" + type + "&action=" + action;
    }

    public Collection<PluginData> getPluginData(Collection<PluginData> previous, String highlightKey) {
        ArrayList<PluginData> plugins = new ArrayList<PluginData>();
        for (Plugin p2 : this.pluginAccessor.getPlugins()) {
            plugins.add(new PluginData(p2, this.pluginAccessor, previous, highlightKey));
        }
        return plugins;
    }

    public static class PluginModuleData {
        private String key;
        private String name;
        private String description;
        private String state;
        private String errorMessage;

        public PluginModuleData(String key, String name, String description, String state, String errorMessage) {
            this.key = key;
            this.name = name;
            if (Strings.isNullOrEmpty((String)name)) {
                this.name = key;
            }
            this.description = description;
            this.state = state;
            this.errorMessage = errorMessage;
        }

        public String getKey() {
            return this.key;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public String getState() {
            return this.state;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public String getActionParameters() {
            return PluginDataFactory.getActionParameters(this.key, PluginDataFactory.MODULE, this.state);
        }

        public String getActionName() {
            return PluginDataFactory.getActionName(this.state);
        }
    }

    public static class PluginNameComparator
    implements Comparator<PluginData> {
        @Override
        public int compare(PluginData left, PluginData right) {
            return left.getName().compareToIgnoreCase(right.getName());
        }
    }

    public static class PluginData {
        private String name;
        private String key;
        private String description;
        private String version;
        private String state;
        private String errorMessage;
        private boolean configurable;
        private List<PluginModuleData> modules = new ArrayList<PluginModuleData>();
        private boolean newlyFound = false;
        private boolean highlighted = false;
        private String vendor;

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            PluginData that = (PluginData)o2;
            return this.key != null ? this.key.equals(that.key) : that.key == null;
        }

        public int hashCode() {
            return this.key != null ? this.key.hashCode() : 0;
        }

        public PluginData(Plugin plugin, PluginAccessor pluginAccessor, Collection<PluginData> previousPlugins, String highlightKey) {
            boolean hasError;
            this.name = plugin.getName();
            this.key = plugin.getKey();
            if (Strings.isNullOrEmpty((String)this.name)) {
                this.name = this.key;
            }
            this.description = (hasError = plugin instanceof UnloadablePlugin) ? "" : plugin.getPluginInformation().getDescription();
            String string = this.version = hasError ? "" : plugin.getPluginInformation().getVersion();
            this.state = hasError ? "Error" : (pluginAccessor.isPluginEnabled(plugin.getKey()) ? "Enabled" : "Disabled");
            this.errorMessage = hasError ? ((UnloadablePlugin)plugin).getErrorText() : "";
            this.newlyFound = previousPlugins != null && !previousPlugins.contains(this);
            this.highlighted = !hasError && highlightKey != null && this.key.equals(highlightKey);
            this.configurable = !hasError && pluginAccessor.isPluginEnabled(plugin.getKey()) && plugin.getPluginInformation().getParameters().get("configure.url") != null;
            boolean allModulesEnabled = true;
            boolean allModulesDisabled = true;
            for (ModuleDescriptor m2 : plugin.getModuleDescriptors()) {
                boolean moduleEnabled;
                boolean moduleHasError = false;
                String errorText = "";
                if (m2 instanceof UnloadableModuleDescriptor) {
                    errorText = ((UnloadableModuleDescriptor)m2).getErrorText();
                    moduleHasError = true;
                }
                if (m2 instanceof UnrecognisedModuleDescriptor) {
                    errorText = ((UnrecognisedModuleDescriptor)m2).getErrorText();
                    moduleHasError = true;
                }
                if (moduleEnabled = pluginAccessor.isPluginModuleEnabled(m2.getCompleteKey())) {
                    allModulesDisabled = false;
                } else {
                    allModulesEnabled = false;
                }
                this.modules.add(new PluginModuleData(m2.getCompleteKey(), m2.getName(), m2.getDescription(), moduleHasError ? "Error" : (moduleEnabled ? "Enabled" : "Disabled"), errorText));
            }
            this.vendor = plugin.getPluginInformation().getVendorName();
            this.modules = Collections.unmodifiableList(this.modules);
            if (!hasError && plugin.getModuleDescriptors().size() > 0) {
                this.errorMessage = "Some modules disabled.";
                if (allModulesDisabled) {
                    this.errorMessage = "All modules disabled.";
                } else if (allModulesEnabled) {
                    this.errorMessage = "All modules enabled.";
                }
            }
        }

        public String getName() {
            return this.name;
        }

        public String getKey() {
            return this.key;
        }

        public String getDescription() {
            return this.description;
        }

        public String getState() {
            return this.state;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public Collection<PluginModuleData> getModules() {
            return this.modules;
        }

        public boolean isNewlyFound() {
            return this.newlyFound;
        }

        public String getActionParameters() {
            return PluginDataFactory.getActionParameters(this.key, PluginDataFactory.PLUGIN, this.state);
        }

        public String getActionName() {
            return PluginDataFactory.getActionName(this.state);
        }

        public boolean isConfigurable() {
            return this.configurable;
        }

        public String getVersion() {
            return this.version;
        }

        public String getVendor() {
            return this.vendor;
        }
    }
}

