/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions.jira;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.fisheye.jira.JiraField;
import com.atlassian.fisheye.jira.JiraServer;
import com.atlassian.fisheye.jira.JiraServerFactory;
import com.atlassian.fisheye.jira.JiraServerService;
import com.atlassian.fisheye.jira.RemoteJiraException;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.FishEyeSysProps;
import com.cenqua.fisheye.logging.Logs;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.opensymphony.xwork.ActionSupport;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;

public class UpdateJiraServerAction
extends ActionSupport {
    @Resource
    private JiraServerService jiraService;
    @Resource
    private JiraServerFactory jiraServerFactory;
    private boolean showActivityItemProviderCheckbox = FishEyeSysProps.JIRA_ACTIVITY_ENABLED;
    private boolean activityItemProvider;
    private boolean allowUnassigned;
    private String name;
    private Long subtaskId;
    private Long subtaskResolutionActionId;
    private Long subtaskResolutionId;
    private String id;
    private String testConnection;
    private JiraServer jiraServer;
    private List<JiraField> issueTypes;
    private List<JiraField> resolutions;
    private String authorisationUri;
    private String jiraServerName;

    @RequireSecurityToken(value=false)
    public String doDefault() throws Exception {
        this.jiraServer = this.jiraService.getJiraServer(new ApplicationId(this.id));
        if (this.jiraServer != null) {
            ApplicationLink link = this.jiraServer.getApplicationLink();
            this.name = link.getName();
            this.activityItemProvider = this.jiraServer.isActivityItemProvider();
            this.allowUnassigned = this.jiraServer.isAllowUnassigned();
            this.allowUnassigned = this.jiraServer.isAllowUnassigned();
            JiraServer.SubtaskConfiguration subtaskConfiguration = this.jiraServer.getSubtaskConfiguration();
            if (subtaskConfiguration != null) {
                this.subtaskId = subtaskConfiguration.getSubtaskId();
                this.subtaskResolutionActionId = subtaskConfiguration.getSubtaskResolutionActionId();
                this.subtaskResolutionId = subtaskConfiguration.getSubtaskResolutionId();
            }
        }
        return "success";
    }

    public void validate() {
    }

    public String execute() throws Exception {
        if (this.isTest()) {
            return this.testConnection();
        }
        this.jiraServer = this.jiraService.getJiraServer(new ApplicationId(this.id));
        if (this.jiraServer == null) {
            this.addActionError(String.format("Cannot update configuration for JIRA server %s. Server does not exist.", this.id));
            return "error";
        }
        this.jiraServer.setActivityItemProvider(this.isActivityItemProvider());
        this.jiraServer.setAllowedUnassigned(this.isAllowUnassigned());
        if (this.getSubtaskId() != null && this.getSubtaskResolutionActionId() != null && this.getSubtaskResolutionId() != null || this.getSubtaskId() == null && this.getSubtaskResolutionActionId() == null && this.getSubtaskResolutionId() == null) {
            this.jiraServer.setSubtaskConfiguration(new JiraServer.SubtaskConfiguration(){

                @Override
                public Long getSubtaskId() {
                    return UpdateJiraServerAction.this.getSubtaskId();
                }

                @Override
                public Long getSubtaskResolutionActionId() {
                    return UpdateJiraServerAction.this.getSubtaskResolutionActionId();
                }

                @Override
                public Long getSubtaskResolutionId() {
                    return UpdateJiraServerAction.this.getSubtaskResolutionId();
                }
            });
        }
        return "success";
    }

    private boolean isTest() {
        return !Strings.isNullOrEmpty((String)this.getTestConnection());
    }

    public String testConnection() throws Exception {
        this.jiraServer = this.jiraService.getJiraServer(new ApplicationId(this.id));
        JiraServer testServer = this.jiraServerFactory.getJiraServer(this.jiraServer.getApplicationLink());
        try {
            if (AppConfig.isCrucible()) {
                this.issueTypes = Lists.newArrayList(testServer.getFieldsOfType(JiraField.Type.SUBTASK_TYPE));
                if (this.issueTypes.isEmpty()) {
                    this.addActionMessage("No subtask issue types found. If you require Defect to Subtask creation, you must first enable subtasks in JIRA.");
                } else {
                    Collections.sort(this.issueTypes, JiraField.NAME_COMPARATOR);
                }
                this.resolutions = Lists.newArrayList(testServer.getFieldsOfType(JiraField.Type.RESOLUTION));
                if (this.resolutions.isEmpty()) {
                    this.addActionMessage("Couldn't resolve resolutions from your JIRA instance.");
                } else {
                    Collections.sort(this.resolutions, JiraField.NAME_COMPARATOR);
                }
            }
            this.addActionMessage("Test Successful");
            return "input";
        }
        catch (CredentialsRequiredException cre) {
            this.authorisationUri = cre.getAuthorisationURI().toString();
            this.jiraServerName = testServer.getApplicationLink().getName();
            return "error";
        }
        catch (Exception e2) {
            this.addActionError(this.prettyConnectionErrorMessage(e2, testServer));
            return "error";
        }
    }

    private String prettyConnectionErrorMessage(Exception e2, JiraServer server) {
        String msg = e2.getMessage();
        if (e2 instanceof IOException) {
            return "Communication error while talking to JIRA: " + msg + " - please ensure that (1) your JIRA server running and (2) you have enabled JIRA's remote API.";
        }
        if (e2 instanceof RemoteJiraException) {
            return "Couldn't send SOAP request to JIRA: " + msg + " - have you enabled your JIRA server's remote API?";
        }
        return msg;
    }

    private URI getCallbackUrl() {
        try {
            return new URI(AppConfig.getsConfig().getSiteURL() + "/admin/updateJiraServer-default.do?id=" + this.id);
        }
        catch (URISyntaxException use) {
            Logs.APP_LOG.error((Object)"Unable to form authorization callback URL for JIRA server login.", (Throwable)use);
            return null;
        }
    }

    public JiraServer getJiraServer() {
        return this.jiraServer;
    }

    public List<JiraField> getIssueTypes() {
        return this.issueTypes;
    }

    public List<JiraField> getResolutions() {
        return this.resolutions;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getSubtaskId() {
        return this.subtaskId;
    }

    public void setSubtaskId(Long subtaskId) {
        this.subtaskId = subtaskId;
    }

    public Long getSubtaskResolutionActionId() {
        return this.subtaskResolutionActionId;
    }

    public void setSubtaskResolutionActionId(Long subtaskResolutionActionId) {
        this.subtaskResolutionActionId = subtaskResolutionActionId;
    }

    public Long getSubtaskResolutionId() {
        return this.subtaskResolutionId;
    }

    public void setSubtaskResolutionId(Long subtaskResolutionId) {
        this.subtaskResolutionId = subtaskResolutionId;
    }

    public boolean isShowActivityItemProviderCheckbox() {
        return this.showActivityItemProviderCheckbox;
    }

    public boolean isActivityItemProvider() {
        return this.activityItemProvider;
    }

    public void setActivityItemProvider(boolean activityItemProvider) {
        this.activityItemProvider = activityItemProvider;
    }

    public boolean isAllowUnassigned() {
        return this.allowUnassigned;
    }

    public void setAllowUnassigned(boolean allowUnassigned) {
        this.allowUnassigned = allowUnassigned;
    }

    public String getTestConnection() {
        return this.testConnection;
    }

    public void setTestConnection(String testConnection) {
        this.testConnection = testConnection;
    }

    public String getAuthorisationUri() {
        return this.authorisationUri;
    }

    public String getJiraServerName() {
        return this.jiraServerName;
    }
}

