/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions.filedownload;

import com.cenqua.fisheye.web.mime.DownloadPolicy;
import com.google.common.base.Preconditions;

public enum PolicyDescription {
    Smart(DownloadPolicy.Smart, "Allow all files to be viewed inline in the browser, except for a blacklist of known 'executable' file extensions. File types in the blacklist will be downloaded via the 'Save As...' dialog."),
    Secure(DownloadPolicy.Secure, "Force all files to be downloaded via the 'Save As...' dialog"),
    Insecure(DownloadPolicy.Insecure, "Allow all files to be viewed inline in the browser");

    private final DownloadPolicy policy;
    private final String description;

    private PolicyDescription(DownloadPolicy policy, String description) {
        this.policy = policy;
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public DownloadPolicy getPolicy() {
        return this.policy;
    }

    public static PolicyDescription forName(DownloadPolicy policy) {
        Preconditions.checkNotNull((Object)((Object)policy), (Object)"Null policy");
        for (PolicyDescription policyDescription : PolicyDescription.values()) {
            if (!policyDescription.getPolicy().equals((Object)policy)) continue;
            return policyDescription;
        }
        throw new IllegalArgumentException("Fatal error : no corresponding description for policy " + (Object)((Object)policy));
    }
}

