/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions;

import com.atlassian.fecru.user.EffectiveUserProvider;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.util.Interval;
import com.cenqua.fisheye.util.ProductUpdatePoller;
import com.cenqua.fisheye.web.admin.util.AdminActionUtils;
import com.opensymphony.xwork.ActionSupport;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;

public class UpdatePollingAction
extends ActionSupport {
    private static final List<String> unitStrings = Arrays.asList("seconds", "minutes", "hours", "days", "weeks", "months", "years");
    private int magnitude;
    private int unit;
    @Resource
    private EffectiveUserProvider effectiveUserProvider;
    private ProductUpdatePoller updatePoller;
    private RootConfig rootConfig;

    @Autowired
    public void setUpdatePoller(ProductUpdatePoller updatePoller) {
        this.updatePoller = updatePoller;
    }

    @Autowired
    public void setRootConfig(RootConfig rootConfig) {
        this.rootConfig = rootConfig;
    }

    public final ConfigDocument.Config getCfg() {
        return AdminActionUtils.getCfg(this, this.effectiveUserProvider, this.rootConfig);
    }

    public int getMagnitude() {
        return this.magnitude;
    }

    public String getUnit() {
        return unitStrings.get(this.unit);
    }

    public List<String> getUnitStrings() {
        return unitStrings;
    }

    public void setMagnitude(int magnitude) {
        this.magnitude = magnitude;
    }

    public void setUnit(String unit) {
        this.unit = unitStrings.indexOf(unit);
    }

    public String enable() throws IOException {
        ConfigDocument.Config cfg = this.getCfg();
        if (!cfg.getCheckForUpdates().getEnabled()) {
            cfg.getCheckForUpdates().setEnabled(true);
            this.saveAndReload();
        }
        return "success";
    }

    public String disable() throws IOException {
        ConfigDocument.Config cfg = this.getCfg();
        if (cfg.getCheckForUpdates().getEnabled()) {
            cfg.getCheckForUpdates().setEnabled(false);
            this.saveAndReload();
        }
        return "success";
    }

    @RequireSecurityToken(value=false)
    public String doDefault() throws IOException {
        if (this.getCfg().isSetCheckForUpdates()) {
            Interval interval = new Interval(this.getCfg().getCheckForUpdates().getInterval());
            this.setMagnitude(interval.getMagnitude().intValue());
            this.unit = interval.getUnit();
        }
        return "success";
    }

    public String edit() throws IOException {
        this.getCfg().getCheckForUpdates().setInterval(new Interval(this.magnitude, this.unit).toString());
        this.saveAndReload();
        return "success";
    }

    private void saveAndReload() throws IOException {
        AppConfig.getsConfig().saveConfig();
        if (this.getCfg().getCheckForUpdates().getEnabled()) {
            this.updatePoller.enable(this.getCfg().getCheckForUpdates().getUrl(), new Interval(this.getCfg().getCheckForUpdates().getInterval()));
        } else {
            this.updatePoller.disable();
        }
    }
}

