/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions;

import com.atlassian.fecru.license.LicenseManager;
import com.atlassian.fecru.user.EffectiveUserProvider;
import com.atlassian.fisheye.trustedapplications.DefaultFisheyeTrustedApplicationsManager;
import com.atlassian.modzdetector.ModzRegistryException;
import com.atlassian.security.auth.trustedapps.TrustedApplication;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.crucible.hibernate.DBControlFactory;
import com.cenqua.crucible.hibernate.DBInfo;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.license.LicenseInfo;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.support.ModzDetectorCache;
import com.cenqua.fisheye.support.ThreadDumpHelper;
import com.cenqua.fisheye.util.LargeNumberFormatter;
import com.cenqua.fisheye.web.admin.actions.plugins.PluginDataFactory;
import com.cenqua.fisheye.web.admin.util.AdminActionUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import com.opensymphony.xwork.ActionSupport;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.math.NumberUtils;

public class SystemInfoAction
extends ActionSupport {
    @Resource
    protected RootConfig rootConfig;
    @Resource
    private EffectiveUserProvider effectiveUserProvider;
    private RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
    private final DecimalFormat df = new DecimalFormat("###");
    private final DecimalFormat pcf = new DecimalFormat("###%");
    private PluginDataFactory pluginDataFactory;
    private Iterable<String> apps;
    @Resource
    private DBControlFactory factory;
    @Resource
    private LicenseManager licenseManager;
    private ModzDetectorCache modz = new ModzDetectorCache();
    private DefaultFisheyeTrustedApplicationsManager trustedApplicationsManager;
    private boolean errorWritingThreadDump;
    private boolean threadDumpWritten;
    private String threadDumpWriteError;
    private String threadDumpFile;

    public SystemInfoAction() {
    }

    @VisibleForTesting
    SystemInfoAction(LicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    public boolean isErrorWritingThreadDump() {
        return this.errorWritingThreadDump;
    }

    public boolean isThreadDumpWritten() {
        return this.threadDumpWritten;
    }

    public String getThreadDumpWriteError() {
        return this.threadDumpWriteError;
    }

    public String getThreadDumpFile() {
        return this.threadDumpFile;
    }

    public String writeThreadDump() {
        try {
            this.errorWritingThreadDump = false;
            File td = ThreadDumpHelper.dumpThreadsToLogDir();
            this.threadDumpFile = td.getAbsolutePath();
            this.threadDumpWritten = true;
        }
        catch (IOException e2) {
            this.errorWritingThreadDump = true;
            this.threadDumpWriteError = e2.getMessage();
        }
        return "success";
    }

    public void setTrustedApplicationsManager(DefaultFisheyeTrustedApplicationsManager trustedApplicationsManager) {
        this.trustedApplicationsManager = trustedApplicationsManager;
    }

    public void setPluginDataFactory(PluginDataFactory pluginDataFactory) {
        this.pluginDataFactory = pluginDataFactory;
    }

    private String getFormattedNum(long num) {
        return LargeNumberFormatter.formatValue(this.df, num);
    }

    public String getTotalMemory() {
        return this.getFormattedNum(Runtime.getRuntime().totalMemory());
    }

    public String getFreeMemory() {
        return this.getFormattedNum(Runtime.getRuntime().freeMemory());
    }

    public String getUsedMemoryPcStr() {
        long total = Runtime.getRuntime().totalMemory();
        long free = Runtime.getRuntime().freeMemory();
        if (total == 0L) {
            return "100%";
        }
        return this.pcf.format((float)(total - free) / (float)total);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFreeMemoryPcStr() {
        long total = Runtime.getRuntime().totalMemory();
        long free = Runtime.getRuntime().freeMemory();
        if (total == 0L) {
            return "0%";
        }
        DecimalFormat decimalFormat = this.pcf;
        synchronized (decimalFormat) {
            return this.pcf.format((float)free / (float)total);
        }
    }

    public final ConfigDocument.Config getCfg() {
        return AdminActionUtils.getCfg(this, this.effectiveUserProvider, this.rootConfig);
    }

    public LicenseInfo getLicense() {
        return this.licenseManager.getLicenseInfo();
    }

    public int getAvailableFeSeats() {
        return this.getLicense().getFisheyeLicense().getMaximumNumberOfUsers() - this.licenseManager.getFishEyeUsersCount();
    }

    public int getExceededFeUsers() {
        return this.licenseManager.getExcessFEUsers();
    }

    public int getAvailableCruSeats() {
        return this.getLicense().getCrucibleLicense().getMaximumNumberOfUsers() - this.licenseManager.getCrucibleUsersCount();
    }

    public int getExceededCruUsers() {
        return this.licenseManager.getExcessCruUsers();
    }

    public String getFisheyeHome() {
        return AppConfig.getAppHome().getAbsolutePath();
    }

    public String getFisheyeInst() {
        return AppConfig.getInstanceDir().getAbsolutePath();
    }

    public String getJavaVersion() {
        return System.getProperty("java.version");
    }

    public String getJavaVendor() {
        return System.getProperty("java.vendor");
    }

    public String getJVMVersion() {
        return System.getProperty("java.vm.specification.version");
    }

    public String getJVMVendor() {
        return System.getProperty("java.vm.specification.vendor");
    }

    public String getJVMImplementationVersion() {
        return System.getProperty("java.vm.version");
    }

    public String getJavaRuntimeName() {
        return System.getProperty("java.runtime.name");
    }

    public String getJavaVMName() {
        return System.getProperty("java.vm.name");
    }

    public String getOSInfo() {
        return System.getProperty("os.name") + " " + System.getProperty("os.version");
    }

    public String getOSArch() {
        return System.getProperty("os.arch");
    }

    public String getUserTimezone() {
        return System.getProperty("user.timezone");
    }

    public String getJVMInputArguments() {
        if (this.runtimeMXBean != null) {
            return String.join((CharSequence)" ", this.runtimeMXBean.getInputArguments());
        }
        return "Unknown";
    }

    public boolean canDumpThreads() {
        return ThreadDumpHelper.canDumpThreads();
    }

    public static ThreadInfo[] getThreadInfos() {
        return ThreadDumpHelper.getThreadInfos();
    }

    @RequireSecurityToken(value=false)
    public String doDefault() throws Exception {
        return super.doDefault();
    }

    public String execute() throws Exception {
        return "success";
    }

    public String forceGC() throws Exception {
        System.gc();
        return "success";
    }

    public Collection<PluginDataFactory.PluginData> getPlugins() {
        ArrayList<PluginDataFactory.PluginData> plugins = new ArrayList<PluginDataFactory.PluginData>();
        plugins.addAll(this.pluginDataFactory.getPluginData(null, null));
        Collections.sort(plugins, new PluginDataFactory.PluginNameComparator());
        return plugins;
    }

    public Iterable<String> getTrustedAppsIds() {
        if (this.apps == null) {
            ArrayList<String> buf = new ArrayList<String>();
            for (TrustedApplication app : this.trustedApplicationsManager.getTrustedApplications()) {
                buf.add(app.getID());
            }
            this.apps = buf;
        }
        return this.apps;
    }

    public boolean hasPlugins() {
        return !this.pluginDataFactory.getPluginData(null, null).isEmpty();
    }

    public boolean hasTrustedApps() {
        return !Iterables.isEmpty(this.trustedApplicationsManager.getTrustedApplications());
    }

    public boolean isDebugEnabled() {
        return Logs.APP_LOG.isDebugEnabled();
    }

    public DBInfo getDbInfo() {
        return this.factory.getCurrentControl().getInfo();
    }

    public String getDbConnectionPoolConfiguredMin() {
        return this.getDbInfo().getConnectionInfo().getMinPoolSize() + "";
    }

    public String getDbConnectionPoolConfiguredMax() {
        return this.getDbInfo().getConnectionInfo().getMaxPoolSize() + "";
    }

    public String getDbConnectionPoolEffectiveMin() {
        return NumberUtils.toInt((String)this.getDbConnectionPoolMinPerPartition()) * NumberUtils.toInt((String)this.getDbConnectionPoolPartitionCount()) + "";
    }

    public String getDbConnectionPoolEffectiveMax() {
        return NumberUtils.toInt((String)this.getDbConnectionPoolMaxPerPartition()) * NumberUtils.toInt((String)this.getDbConnectionPoolPartitionCount()) + "";
    }

    public String getDbConnectionPoolPartitionCount() {
        return HibernateUtil.getCfg().getProperty("bonecp.partitionCount");
    }

    public String getDbConnectionPoolMinPerPartition() {
        return HibernateUtil.getCfg().getProperty("bonecp.minConnectionsPerPartition");
    }

    public String getDbConnectionPoolMaxPerPartition() {
        return HibernateUtil.getCfg().getProperty("bonecp.maxConnectionsPerPartition");
    }

    public Integer getDbVersion() {
        return this.factory.getCurrentControl().getInfo().currentVersion();
    }

    public String getCrowdVersion() {
        return "2.8.5-m1";
    }

    public List getModifiedFiles() {
        try {
            if (this.modz.getModifications().modifiedFiles.isEmpty()) {
                return Collections.emptyList();
            }
            return this.modz.getModifications().modifiedFiles;
        }
        catch (ModzRegistryException e2) {
            Logs.APP_LOG.warn((Object)("Problems calculating modified files: " + e2.getMessage()));
            return Collections.emptyList();
        }
    }

    public List getRemovedFiles() {
        try {
            if (this.modz.getModifications().removedFiles.isEmpty()) {
                return Collections.emptyList();
            }
            return this.modz.getModifications().removedFiles;
        }
        catch (ModzRegistryException e2) {
            Logs.APP_LOG.warn((Object)("Problems calculating removed files: " + e2.getMessage()));
            return Collections.emptyList();
        }
    }
}

