/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions;

import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.IndexingOptions;
import com.cenqua.fisheye.logging.Logs;
import com.opensymphony.xwork.ActionSupport;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;

public final class ShutdownAction
extends ActionSupport {
    private static final String MESSAGE_FOR_OPT_INDEX = "Scheduling optimization of the indexes for next start.";
    private static final String MESSAGE_SHUTDOWN = AppConfig.getProductName() + (AppConfig.isFishEyeOnly() || AppConfig.isCrucibleOnly() ? " is " : " are ") + "shutting down.";
    private String optimizeIndexes;

    @RequireSecurityToken(value=false)
    public String execute() {
        return "success";
    }

    public String doShutdown() {
        if (StringUtils.isNotBlank((String)this.optimizeIndexes)) {
            this.log(MESSAGE_FOR_OPT_INDEX);
            this.scheduleOptimise();
        }
        this.log(MESSAGE_SHUTDOWN);
        this.beginShutdown();
        return "success";
    }

    private void log(String message) {
        this.addActionMessage(message);
        Logs.APP_LOG.info((Object)message);
    }

    private void beginShutdown() {
        Runnable r2 = new Runnable(){

            @Override
            public void run() {
                try {
                    long sleep = 5000L;
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                AppConfig.getShutdown().stop();
            }
        };
        Thread t2 = new Thread(r2, "GUI Shutdown");
        t2.start();
    }

    private void scheduleOptimise() {
        IndexingOptions indexes;
        ConfigDocument.Config config = AppConfig.getsConfig().getConfig();
        IndexingOptions indexingOptions = indexes = config.isSetIndexingOptions() ? config.getIndexingOptions() : config.addNewIndexingOptions();
        if (!indexes.isSetOptimizeIndexesOnNextStartup()) {
            indexes.addNewOptimizeIndexesOnNextStartup();
            this.saveConfig();
        }
    }

    private void saveConfig() {
        try {
            AppConfig.getsConfig().saveConfig();
        }
        catch (IOException e2) {
            Logs.APP_LOG.error((Object)"Could not schedule the optimisation of the indexes", (Throwable)e2);
        }
    }

    public void setOptimizeIndexes(String optimizeIndexes) {
        this.optimizeIndexes = optimizeIndexes;
    }
}

