/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions;

import com.atlassian.fisheye.spi.data.MailMessageData;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.mail.Mailer;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.user.UserManager;
import com.opensymphony.webwork.interceptor.ServletRequestAware;
import com.opensymphony.xwork.ActionSupport;
import java.io.StringWriter;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.NDC;

public class SendTestEmailAction
extends ActionSupport
implements ServletRequestAware {
    @Resource
    private UserManager userManager;
    @Resource
    private Mailer mailer;
    private String to;
    private String subject = "Test email from FishEye 4.0.4";
    private String message = "This is a test email from FishEye 4.0.4";
    private String from;
    private String maillog;
    private HttpServletRequest request;

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMaillog() {
        return this.maillog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute() throws Exception {
        if (SendTestEmailAction.nullOrEmpty(this.to)) {
            this.addFieldError("to", "Please enter a recipient address for the test email");
            return "input";
        }
        StringWriter logBuffer = new StringWriter();
        String ndc = "test-email-" + System.currentTimeMillis();
        Appender appender = Logs.makeTestAppender(logBuffer, ndc, null);
        Level currentLevel = Logs.MAIL_LOG.getLevel();
        try {
            NDC.push((String)ndc);
            Logs.MAIL_LOG.setLevel(Level.DEBUG);
            Logs.MAIL_LOG.addAppender(appender);
            this.mailer.reload(AppConfig.getsConfig().getConfig().getSmtp());
            MailMessageData msg = new MailMessageData();
            msg.setFrom(this.from);
            msg.addRecipient(this.to);
            msg.setSubject(this.subject);
            msg.setBodyText("text/plain; charset=UTF-8", this.message);
            if (this.mailer.sendMessage(msg)) {
                Logs.MAIL_LOG.info((Object)"Test mail sent successfully.");
            }
        }
        catch (Exception e2) {
            Logs.MAIL_LOG.error((Object)("Problem sending mail - " + e2.getClass()), (Throwable)e2);
            String string = "error";
            return string;
        }
        finally {
            Logs.MAIL_LOG.removeAppender(appender);
            Logs.MAIL_LOG.setLevel(currentLevel);
            NDC.pop();
            this.maillog = logBuffer.toString();
        }
        return "success";
    }

    @RequireSecurityToken(value=false)
    public String doDefault() throws Exception {
        UserLogin user = this.userManager.getCurrentUser(this.request);
        if (user != null) {
            this.to = this.userManager.getUser(user.getUsername()).getEmail();
        }
        return "success";
    }

    private static boolean nullOrEmpty(String s2) {
        return s2 == null || s2.trim().length() == 0;
    }

    public void setServletRequest(HttpServletRequest httpServletRequest) {
        this.request = httpServletRequest;
    }
}

