/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions;

import com.atlassian.crucible.migration.BackupFrequency;
import com.atlassian.crucible.migration.BackupItem;
import com.atlassian.crucible.migration.BackupManagerImpl;
import com.atlassian.crucible.migration.ScheduledBackupJob;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.util.Pair;
import com.cenqua.fisheye.web.JspUtils;
import com.cenqua.fisheye.web.admin.actions.BaseBackupAction;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;

public class ScheduleBackupAction
extends BaseBackupAction {
    private boolean disabled;
    private Collection<String> selectedItems;
    private String prefix = new JspUtils().getAppName().toLowerCase().replaceAll("[^\\w]", "") + "_backup_";
    private String datePattern = "yyyy_MM_dd";
    private BackupFrequency frequency;
    private String time;
    private String showPane;

    public String getShowPane() {
        return this.showPane;
    }

    public void setShowPane(String showPane) {
        this.showPane = showPane;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public LinkedHashMap<String, String> getAvailableFrequencies() {
        LinkedHashMap<String, String> freqs = new LinkedHashMap<String, String>();
        for (BackupFrequency freq : BackupFrequency.values()) {
            freqs.put(freq.name(), freq.getDescription());
        }
        return freqs;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    public void setDatePattern(String datePattern) {
        this.datePattern = datePattern;
    }

    public String getFrequency() {
        return this.frequency.name();
    }

    public String getFrequencyDescription() {
        return this.frequency.getDescription();
    }

    public void setFrequency(String frequency) {
        this.frequency = BackupFrequency.valueOf(frequency);
    }

    public String getTime() {
        return this.time;
    }

    public void setTime(String time) throws IllegalArgumentException {
        this.time = time;
    }

    public void setSelectedItems(Collection<String> selectedItems) {
        this.selectedItems = selectedItems;
    }

    @Override
    @RequireSecurityToken(value=false)
    public String execute() throws Exception {
        ScheduledBackupJob job = this.backupManager.getScheduledBackupJob();
        this.disabled = null == job;
        if (this.disabled) {
            this.time = "01:00";
            this.frequency = BackupFrequency.valueOf(this.getAvailableFrequencies().keySet().iterator().next());
        } else {
            this.prefix = job.getPrefix();
            this.datePattern = job.getDatePattern();
            this.time = job.getTime();
            this.frequency = job.getFrequency();
            this.selectedItems = job.getItems();
        }
        return "success";
    }

    @Override
    public Map<String, Pair<String, Boolean>> getNonMandatoryBackupItems() {
        TreeMap<String, Pair<String, Boolean>> items = new TreeMap<String, Pair<String, Boolean>>();
        for (Map.Entry entry : BackupManagerImpl.items.entrySet()) {
            BackupItem item = (BackupItem)entry.getValue();
            if (item.isMandatory()) continue;
            boolean selected = this.selectedItems == null ? ((BackupItem)entry.getValue()).isDefault() : this.selectedItems.contains(entry.getKey());
            items.put((String)entry.getKey(), Pair.newInstance(((BackupItem)entry.getValue()).getDescription(), selected));
        }
        return items;
    }

    public String doSave() throws Exception {
        if (this.disabled) {
            ScheduledBackupJob job = this.backupManager.getScheduledBackupJob();
            if (job != null) {
                job.cancel();
                this.selectedItems = job.getItems();
                Logs.APP_LOG.info((Object)"Scheduled backups disabled.");
            } else {
                this.selectedItems = null;
            }
        } else {
            this.backupManager.enableScheduledBackups(this.prefix, this.datePattern, this.frequency, this.time, this.selectedItems == null ? Collections.emptyList() : this.selectedItems);
            Logs.APP_LOG.info((Object)String.format("Scheduled backups enabled %s at %s", this.frequency.getDescription(), this.time));
        }
        return "success";
    }
}

