/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions;

import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.managers.ProjectManager;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.model.ContentRoot;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.web.admin.actions.BaseAdminAction;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;

public class ProjectContentRootAdminAction
extends BaseAdminAction {
    @Resource
    private ProjectManager manager;
    private int id;
    private String path;
    private String rep;
    private boolean wholeRep;
    private Project project;

    @RequireSecurityToken(value=false)
    public String viewProject() {
        return "success";
    }

    public String deletePath() {
        this.manager.deletePathFromProject(this.getProject().getProjKey(), this.rep, this.path);
        return "success";
    }

    public String addPath() {
        if (!this.checkPath()) {
            return "error";
        }
        Set<String> reps = this.manager.getAllRepositoriesInProject(this.project);
        if (reps.contains(this.rep)) {
            List<ContentRoot> paths = this.project.getAllContentRootsForRep(this.rep);
            for (ContentRoot cr : paths) {
                Path newPath;
                Path current = new Path(cr.getPath());
                if (!current.isAncestor(newPath = new Path(this.path))) continue;
                this.addActionMessage("Adding " + newPath.getPath() + " is redundant as it is contained within " + StringUtils.defaultIfEmpty((String)current.getPath(), (String)"/"));
            }
        }
        if (this.isWholeRep()) {
            if (!this.project.contentRootExists(this.rep, "/")) {
                this.manager.addRepToProject(this.project.getProjKey(), this.rep);
            } else {
                this.addActionMessage("Directory was not added as it is already present in the project");
            }
        } else {
            this.manager.addPathToProject(this.project.getProjKey(), this.rep, this.path);
        }
        return "success";
    }

    public boolean isWholeRep() {
        return this.wholeRep;
    }

    public void setWholeRep(boolean wholeRep) {
        this.wholeRep = wholeRep;
    }

    public List<Project> getProjects() {
        return this.manager.getAllProjects();
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getRep() {
        Project projectById;
        if (this.rep == null && (projectById = this.manager.getProjectById(this.id)) != null) {
            return projectById.getDefaultRepositoryName();
        }
        return this.rep;
    }

    public void setRep(String rep) {
        this.rep = rep;
    }

    public List<String> getAllRepnames() {
        List<RepositoryHandle> handles = this.repositoryManager.getHandles();
        ArrayList<String> names = new ArrayList<String>(handles.size());
        for (RepositoryHandle handle : handles) {
            if (!handle.isRunning()) continue;
            names.add(handle.getName());
        }
        return names;
    }

    public Project getProject() {
        return this.project;
    }

    public Set<ContentRoot> getContentRoots() {
        return this.project.getContentRoots();
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        if (this.project == null) {
            this.project = this.manager.getProjectById(id);
        }
        this.id = id;
    }

    private boolean checkPath() {
        boolean result = false;
        if (this.wholeRep) {
            result = true;
        } else if (Strings.isNullOrEmpty((String)this.path)) {
            this.addFieldError("path", "Please enter a path or check the 'use whole repository' field.");
        } else {
            try {
                RepositoryHandle handle = this.repositoryManager.getRepository(this.rep);
                if (handle == null) {
                    this.addFieldError("rep", "Repository does not exist.");
                } else {
                    RevisionCache<? extends ChangeSet> cache = handle.acquireEngine().getRevisionCache();
                    result = cache.isDir(new Path(this.path));
                    if (!result) {
                        this.addFieldError("path", this.path + " is not a valid path in repository " + this.rep);
                    }
                }
            }
            catch (RepositoryHandle.StateException e2) {
                this.addActionError("Repository " + this.rep + " is currently not active");
            }
            catch (DbException e3) {
                this.addActionError("Problem accessing database");
            }
        }
        return result;
    }
}

