/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions;

import com.atlassian.crucible.actions.AjaxResponse;
import com.atlassian.crucible.migration.BackupManager;
import com.atlassian.crucible.migration.BackupStatus;
import com.atlassian.crucible.migration.item.Message;
import com.cenqua.fisheye.util.Pair;
import com.cenqua.fisheye.web.admin.actions.BaseAdminAction;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;

public class PerformBackupAjaxAction
extends BaseAdminAction
implements AjaxResponse {
    @Resource(name="backupManager")
    private BackupManager backupManager;
    static final String BACKUP_PROGRESS_SESSION_KEY = PerformBackupAjaxAction.class.getName() + ".backupProgress";
    private Collection<String> includeItems = null;
    private int line = 0;
    private String path;
    private BackupStatus.State state;
    private Collection<String> completedItems;
    private Collection<String> pendingItems;
    private String currentItem;
    private List<Pair<String, String>> output = new ArrayList<Pair<String, String>>();
    private File file;

    public void setLine(int line) {
        this.line = line;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String doStart() throws Exception {
        if (this.backupManager.getStatus() == null || this.backupManager.getStatus().getState() != BackupStatus.State.RUNNING) {
            File backupFile = this.backupManager.returnAndCreateBackupWithName(this.path, this.includeItems == null ? Collections.emptySet() : this.includeItems, Collections.emptyMap(), null);
            this.getRequest().getSession().setAttribute(BACKUP_PROGRESS_SESSION_KEY, (Object)backupFile.getCanonicalPath());
        }
        return "none";
    }

    public String doProgress() throws IOException {
        BackupStatus status = this.backupManager.getStatus();
        if (status != null) {
            this.state = status.getState();
            this.completedItems = new ArrayList<String>(status.getCompletedItems());
            this.pendingItems = new ArrayList<String>(status.getPendingItems());
            this.currentItem = status.getCurrentItem();
            this.file = status.getFile();
            boolean hasSessionKey = Objects.equals(this.getRequest().getSession().getAttribute(BACKUP_PROGRESS_SESSION_KEY), this.file.getCanonicalPath());
            if (!hasSessionKey) {
                return "error";
            }
            ArrayList<Message> all = new ArrayList<Message>(status.getOutput());
            if (this.line < all.size()) {
                for (Message m2 : all.subList(this.line, all.size())) {
                    String type = m2.isWarning() ? "backupErrorMessage" : "backupUpdateMessage";
                    this.output.add(Pair.newInstance(m2.getMessage(), type));
                }
            }
        }
        return "success";
    }

    public void setIncludeItems(String[] includeItems) {
        this.includeItems = Arrays.asList(includeItems);
    }

    public List<Pair<String, String>> getOutput() {
        return this.output;
    }

    public String getState() {
        return this.state.toString();
    }

    public Collection<String> getCompletedItems() {
        return this.completedItems;
    }

    public Collection<String> getPendingItems() {
        return this.pendingItems;
    }

    public String getCurrentItem() {
        return this.currentItem;
    }

    public String getFileName() {
        return this.file.getPath();
    }

    public long getFileSize() {
        return this.file.length();
    }

    @Override
    public String getErrorMsg() {
        return "";
    }

    @Override
    public boolean isWorked() {
        return true;
    }
}

