/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions;

import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.AdminConfig;
import com.cenqua.fisheye.user.AdminUserConfig;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.web.admin.interceptors.LoginInterceptor;
import com.cenqua.fisheye.web.util.SafeRedirectChecker;
import com.google.common.base.Strings;
import com.opensymphony.webwork.ServletActionContext;
import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.ActionSupport;
import java.util.Map;
import javax.annotation.Resource;

public class LoginAction
extends ActionSupport {
    @Resource
    private UserManager userManager;
    @Resource
    private SafeRedirectChecker safeRedirectChecker;
    @Resource
    private AdminUserConfig adminUserConfig;
    private String password;
    private String successURL;
    private String errormsg;
    private String origUrl;

    public void setAdminPassword(String password) {
        this.password = password;
    }

    public void setOrigUrl(String origUrl) {
        this.origUrl = origUrl;
    }

    public String getSuccessURL() {
        return this.successURL;
    }

    public String getErrormsg() {
        return this.errormsg;
    }

    public boolean isHasErrors() {
        return this.errormsg != null;
    }

    public boolean isAdminEnabled() {
        return this.isRootAdminEnabled() || this.isUserAdminEnabled();
    }

    public boolean isRootAdminEnabled() {
        return this.getAdminConfig().isAdminEnabled();
    }

    public boolean isUserAdminEnabled() {
        return this.adminUserConfig.areSysAdminsSet();
    }

    @RequireSecurityToken(value=false)
    public String execute() throws Exception {
        AdminConfig admin = this.getAdminConfig();
        if (!admin.isAdminEnabled()) {
            this.errormsg = "Administrator account log in is disabled.";
            return "input";
        }
        if (!AppConfig.getsConfig().getAdminConfig().verifyAdminPassword(this.password)) {
            this.errormsg = "Password incorrect";
            return "input";
        }
        ActionContext ctx = ActionContext.getContext();
        Map session = ctx.getSession();
        session.put(LoginInterceptor.SESSION_KEY, LoginInterceptor.SESSION_KEY);
        this.successURL = this.getReturnURI();
        if (!this.safeRedirectChecker.canRedirectTo(this.successURL)) {
            this.successURL = "";
        }
        return "success";
    }

    private String getReturnURI() {
        String sessionReturnURI = (String)ActionContext.getContext().getSession().get(LoginInterceptor.SUCCESS_URL_KEY);
        return Strings.isNullOrEmpty((String)this.origUrl) ? sessionReturnURI : this.origUrl;
    }

    @RequireSecurityToken(value=false)
    public String doDefault() throws Exception {
        if (this.userManager.hasSysAdminPrivileges(ServletActionContext.getRequest())) {
            return AppConfig.isCrucibleOnly() ? "adminCru" : "adminUser";
        }
        this.successURL = this.getReturnURI();
        return "success";
    }

    private AdminConfig getAdminConfig() {
        return AppConfig.getsConfig().getAdminConfig();
    }
}

