/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions;

import com.cenqua.fisheye.logging.Logs;
import java.io.Serializable;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.event.CacheEventListener;
import org.hibernate.cache.spi.entry.CollectionCacheEntry;

public class InspectCacheEventListener
implements CacheEventListener {
    public void notifyElementRemoved(Ehcache cache, Element element) throws CacheException {
        this.logit("removed", cache, element);
    }

    private void logit(String msg, Ehcache cache, Element element) {
        StringBuilder b2 = new StringBuilder();
        b2.append(cache.getName()).append(msg).append(element);
        Serializable v2 = element.getValue();
        if (v2 instanceof CollectionCacheEntry) {
            CollectionCacheEntry e2 = (CollectionCacheEntry)v2;
            b2.append("entry value [").append(e2.getState().length).append("]\n");
            for (Serializable s2 : e2.getState()) {
                b2.append(s2).append(" ");
            }
        }
        Logs.APP_LOG.info((Object)b2.toString());
    }

    public void notifyElementPut(Ehcache cache, Element element) throws CacheException {
        this.logit("added", cache, element);
    }

    public void notifyElementUpdated(Ehcache cache, Element element) throws CacheException {
        this.logit("updated", cache, element);
    }

    public void notifyElementExpired(Ehcache cache, Element element) {
        this.logit("expired", cache, element);
    }

    public void notifyElementEvicted(Ehcache cache, Element element) {
        this.logit("evicted", cache, element);
    }

    public void notifyRemoveAll(Ehcache cache) {
        Logs.APP_LOG.info((Object)(cache.getName() + " removed all"));
    }

    public void dispose() {
    }

    public Object clone() throws CloneNotSupportedException {
        super.clone();
        throw new CloneNotSupportedException();
    }
}

