/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;

public class HtmlTesterLayout
extends Layout {
    private static final Map<Level, String> DEFAULT_STYLE = new HashMap<Level, String>();
    private static final int NUM_TRACE_LINES = 5;
    private final Map<Level, String> mStyle;
    private final String ndc;
    private final boolean escapeHTML;

    public HtmlTesterLayout(Map<Level, String> mStyle, String ndc, boolean escapeHTML) {
        this.mStyle = mStyle;
        this.ndc = ndc;
        this.escapeHTML = escapeHTML;
    }

    public HtmlTesterLayout(Map<Level, String> mStyle, String ndc) {
        this(mStyle, ndc, false);
    }

    public HtmlTesterLayout(String ndc) {
        this(DEFAULT_STYLE, ndc, false);
    }

    public static Map<Level, String> getDefaultStyle() {
        return new HashMap<Level, String>(DEFAULT_STYLE);
    }

    public String format(LoggingEvent loggingEvent) {
        if (loggingEvent.getNDC() == null || !loggingEvent.getNDC().equals(this.ndc)) {
            return "";
        }
        Level level = loggingEvent.getLevel();
        String logStyle = this.mStyle != null ? (this.mStyle.containsKey(level) ? this.mStyle.get(level) : "") : "";
        StringBuilder row = new StringBuilder();
        row.append("<p style=\"").append(logStyle).append("\">");
        row.append(this.conditionalEscape(loggingEvent.getMessage()));
        ThrowableInformation ti = loggingEvent.getThrowableInformation();
        if (ti != null) {
            Throwable t2 = ti.getThrowable();
            while (t2.getCause() != null) {
                t2 = t2.getCause();
            }
            if (t2.getMessage() != null) {
                row.append("<br/>").append(this.conditionalEscape(t2.getMessage()).replaceAll("\n", "<br/>"));
            }
            StackTraceElement[] trace = t2.getStackTrace();
            for (int i2 = 0; trace != null && i2 < trace.length && i2 < 5; ++i2) {
                row.append("<br/>").append(this.conditionalEscape("at " + trace[i2].toString()));
            }
        }
        return row.append("</p>").toString();
    }

    private String conditionalEscape(Object message) {
        String s2 = String.valueOf(message);
        return this.escapeHTML ? StringEscapeUtils.escapeHtml((String)s2) : s2;
    }

    public String getContentType() {
        return "text/html";
    }

    public boolean ignoresThrowable() {
        return false;
    }

    public void activateOptions() {
    }

    static {
        DEFAULT_STYLE.put(Level.ERROR, "color: #c22; font-weight: bold;");
        DEFAULT_STYLE.put(Level.FATAL, "color: #c22; font-weight: bold;");
        DEFAULT_STYLE.put(Level.WARN, "color: #da0; font-weight: bold;");
        DEFAULT_STYLE.put(Level.INFO, "color: #008000; font-weight: bold;");
        DEFAULT_STYLE.put(Level.DEBUG, "color: #999;");
    }
}

